/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceUtils.class);
    public static final String CLASSPATH_URL_PREFIX = "classpath:";

    public static boolean resourceExists(Object classLoaderSource, String filePath) {
        return ResourceUtils.resourceExists(classLoaderSource.getClass().getClassLoader(), filePath);
    }

    public static boolean resourceExists(ClassLoader classLoader, String filePath) {
        File resourceFile;
        boolean classPathResource = false;
        String path = filePath;
        if (path.startsWith(CLASSPATH_URL_PREFIX)) {
            path = path.substring(CLASSPATH_URL_PREFIX.length());
            classPathResource = true;
        }
        if (!classPathResource && (resourceFile = new File(path)).exists()) {
            return true;
        }
        InputStream classPathStream = classLoader.getResourceAsStream(path);
        if (classPathStream != null) {
            return true;
        }
        try {
            URL url = Resources.getResource((String)path);
            if (url != null) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public static InputStream getInputStream(Object classLoaderSource, String filePath) {
        return ResourceUtils.getInputStream(classLoaderSource.getClass().getClassLoader(), filePath);
    }

    public static InputStream getInputStream(ClassLoader classLoader, String filePath) {
        boolean classPathResource = false;
        String path = filePath;
        if (path.startsWith(CLASSPATH_URL_PREFIX)) {
            path = path.substring(CLASSPATH_URL_PREFIX.length());
            classPathResource = true;
        }
        try {
            File resourceFile;
            if (!classPathResource && (resourceFile = new File(path)).exists()) {
                log.info("Reading resource data from file {}", (Object)filePath);
                return new FileInputStream(resourceFile);
            }
            InputStream classPathStream = classLoader.getResourceAsStream(path);
            if (classPathStream != null) {
                log.info("Reading resource data from class path {}", (Object)filePath);
                return classPathStream;
            }
            URL url = Resources.getResource((String)path);
            if (url != null) {
                URI uri = url.toURI();
                log.info("Reading resource data from URI {}", (Object)filePath);
                return new FileInputStream(new File(uri));
            }
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                log.warn("Unable to find resource: " + filePath);
            }
            log.warn("Unable to find resource: " + filePath, (Throwable)e);
        }
        throw new RuntimeException("Unable to find resource: " + filePath);
    }

    public static String getUri(Object classLoaderSource, String filePath) {
        return ResourceUtils.getUri(classLoaderSource.getClass().getClassLoader(), filePath);
    }

    public static String getUri(ClassLoader classLoader, String filePath) {
        try {
            File resourceFile = new File(filePath);
            if (resourceFile.exists()) {
                log.info("Reading resource data from file {}", (Object)filePath);
                return resourceFile.getAbsolutePath();
            }
            URL url = classLoader.getResource(filePath);
            return url.toURI().toString();
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                log.warn("Unable to find resource: " + filePath);
            } else {
                log.warn("Unable to find resource: " + filePath, (Throwable)e);
            }
            throw new RuntimeException("Unable to find resource: " + filePath);
        }
    }
}

