/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasTitle;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.OtaPackageId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.ota.ChecksumAlgorithm;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class OtaPackageInfo
extends BaseDataWithAdditionalInfo<OtaPackageId>
implements TenantEntity,
HasName,
HasTitle,
ExportableEntity<OtaPackageId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OtaPackageInfo.class);
    private static final long serialVersionUID = 3168391583570815419L;
    @Schema(description="JSON object with Tenant Id. Tenant Id of the ota package can't be changed.", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @Schema(description="JSON object with Device Profile Id. Device Profile Id of the ota package can't be changed.", accessMode=Schema.AccessMode.READ_ONLY)
    private DeviceProfileId deviceProfileId;
    @Schema(description="OTA Package type.", example="FIRMWARE", accessMode=Schema.AccessMode.READ_ONLY)
    private OtaPackageType type;
    @Length(fieldName="title")
    @NoXss
    @Schema(description="OTA Package title.", example="fw", accessMode=Schema.AccessMode.READ_ONLY)
    private String title;
    @Length(fieldName="version")
    @NoXss
    @Schema(description="OTA Package version.", example="1.0", accessMode=Schema.AccessMode.READ_ONLY)
    private String version;
    @Length(fieldName="tag")
    @NoXss
    @Schema(description="OTA Package tag.", example="fw_1.0", accessMode=Schema.AccessMode.READ_ONLY)
    private String tag;
    @Length(fieldName="url")
    @NoXss
    @Schema(description="OTA Package url.", example="http://thingsboard.org/fw/1", accessMode=Schema.AccessMode.READ_ONLY)
    private String url;
    @Schema(description="Indicates OTA Package 'has data'. Field is returned from DB ('true' if data exists or url is set).  If OTA Package 'has data' is 'false' we can not assign the OTA Package to the Device or Device Profile.", example="true", accessMode=Schema.AccessMode.READ_ONLY)
    private boolean hasData;
    @Length(fieldName="file name")
    @NoXss
    @Schema(description="OTA Package file name.", example="fw_1.0", accessMode=Schema.AccessMode.READ_ONLY)
    private String fileName;
    @NoXss
    @Length(fieldName="contentType")
    @Schema(description="OTA Package content type.", example="APPLICATION_OCTET_STREAM", accessMode=Schema.AccessMode.READ_ONLY)
    private String contentType;
    @Schema(description="OTA Package checksum algorithm.", example="CRC32", accessMode=Schema.AccessMode.READ_ONLY)
    private ChecksumAlgorithm checksumAlgorithm;
    @Length(fieldName="checksum", max=1020)
    @Schema(description="OTA Package checksum.", example="0xd87f7e0c", accessMode=Schema.AccessMode.READ_ONLY)
    private String checksum;
    @Schema(description="OTA Package data size.", example="8", accessMode=Schema.AccessMode.READ_ONLY)
    private Long dataSize;
    private OtaPackageId externalId;

    public OtaPackageInfo() {
    }

    public OtaPackageInfo(OtaPackageId id) {
        super(id);
    }

    public OtaPackageInfo(OtaPackageInfo otaPackageInfo) {
        super(otaPackageInfo);
        this.tenantId = otaPackageInfo.getTenantId();
        this.deviceProfileId = otaPackageInfo.getDeviceProfileId();
        this.type = otaPackageInfo.getType();
        this.title = otaPackageInfo.getTitle();
        this.version = otaPackageInfo.getVersion();
        this.tag = otaPackageInfo.getTag();
        this.url = otaPackageInfo.getUrl();
        this.hasData = otaPackageInfo.isHasData();
        this.fileName = otaPackageInfo.getFileName();
        this.contentType = otaPackageInfo.getContentType();
        this.checksumAlgorithm = otaPackageInfo.getChecksumAlgorithm();
        this.checksum = otaPackageInfo.getChecksum();
        this.dataSize = otaPackageInfo.getDataSize();
        this.externalId = otaPackageInfo.getExternalId();
    }

    @Override
    @Schema(description="JSON object with the ota package Id. Specify existing ota package Id to update the ota package. Referencing non-existing ota package id will cause error. Omit this field to create new ota package.")
    public OtaPackageId getId() {
        return (OtaPackageId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the ota package creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getName() {
        return this.title;
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.OTA_PACKAGE;
    }

    @JsonIgnore
    public boolean hasUrl() {
        return StringUtils.isNotEmpty(this.url);
    }

    @Override
    @Schema(description="OTA Package description.", example="Description for the OTA Package fw_1.0")
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public DeviceProfileId getDeviceProfileId() {
        return this.deviceProfileId;
    }

    @Generated
    public OtaPackageType getType() {
        return this.type;
    }

    @Override
    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public boolean isHasData() {
        return this.hasData;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public ChecksumAlgorithm getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    @Generated
    public String getChecksum() {
        return this.checksum;
    }

    @Generated
    public Long getDataSize() {
        return this.dataSize;
    }

    @Override
    @Generated
    public OtaPackageId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setDeviceProfileId(DeviceProfileId deviceProfileId) {
        this.deviceProfileId = deviceProfileId;
    }

    @Generated
    public void setType(OtaPackageType type) {
        this.type = type;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setHasData(boolean hasData) {
        this.hasData = hasData;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Generated
    public void setChecksumAlgorithm(ChecksumAlgorithm checksumAlgorithm) {
        this.checksumAlgorithm = checksumAlgorithm;
    }

    @Generated
    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    @Generated
    public void setDataSize(Long dataSize) {
        this.dataSize = dataSize;
    }

    @Override
    @Generated
    public void setExternalId(OtaPackageId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public String toString() {
        return "OtaPackageInfo(tenantId=" + String.valueOf(this.getTenantId()) + ", deviceProfileId=" + String.valueOf(this.getDeviceProfileId()) + ", type=" + String.valueOf((Object)this.getType()) + ", title=" + this.getTitle() + ", version=" + this.getVersion() + ", tag=" + this.getTag() + ", url=" + this.getUrl() + ", hasData=" + this.isHasData() + ", fileName=" + this.getFileName() + ", contentType=" + this.getContentType() + ", checksumAlgorithm=" + String.valueOf((Object)this.getChecksumAlgorithm()) + ", checksum=" + this.getChecksum() + ", dataSize=" + this.getDataSize() + ", externalId=" + String.valueOf(this.getExternalId()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OtaPackageInfo)) {
            return false;
        }
        OtaPackageInfo other = (OtaPackageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isHasData() != other.isHasData()) {
            return false;
        }
        Long this$dataSize = this.getDataSize();
        Long other$dataSize = other.getDataSize();
        if (this$dataSize == null ? other$dataSize != null : !((Object)this$dataSize).equals(other$dataSize)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        DeviceProfileId this$deviceProfileId = this.getDeviceProfileId();
        DeviceProfileId other$deviceProfileId = other.getDeviceProfileId();
        if (this$deviceProfileId == null ? other$deviceProfileId != null : !((Object)this$deviceProfileId).equals(other$deviceProfileId)) {
            return false;
        }
        OtaPackageType this$type = this.getType();
        OtaPackageType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        ChecksumAlgorithm this$checksumAlgorithm = this.getChecksumAlgorithm();
        ChecksumAlgorithm other$checksumAlgorithm = other.getChecksumAlgorithm();
        if (this$checksumAlgorithm == null ? other$checksumAlgorithm != null : !((Object)((Object)this$checksumAlgorithm)).equals((Object)other$checksumAlgorithm)) {
            return false;
        }
        String this$checksum = this.getChecksum();
        String other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum)) {
            return false;
        }
        OtaPackageId this$externalId = this.getExternalId();
        OtaPackageId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OtaPackageInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isHasData() ? 79 : 97);
        Long $dataSize = this.getDataSize();
        result = result * 59 + ($dataSize == null ? 43 : ((Object)$dataSize).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        DeviceProfileId $deviceProfileId = this.getDeviceProfileId();
        result = result * 59 + ($deviceProfileId == null ? 43 : ((Object)$deviceProfileId).hashCode());
        OtaPackageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        ChecksumAlgorithm $checksumAlgorithm = this.getChecksumAlgorithm();
        result = result * 59 + ($checksumAlgorithm == null ? 43 : ((Object)((Object)$checksumAlgorithm)).hashCode());
        String $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
        OtaPackageId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }
}

