/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EventId;
import org.thingsboard.server.common.data.id.TenantId;

@Schema
public class EventInfo
extends BaseData<EventId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventInfo.class);
    @Schema(description="JSON object with Tenant Id.", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @Schema(description="Event type", example="STATS")
    private String type;
    @Schema(description="string", example="784f394c-42b6-435a-983c-b7beff2784f9")
    private String uid;
    @Schema(description="JSON object with Entity Id for which event is created.", accessMode=Schema.AccessMode.READ_ONLY)
    private EntityId entityId;
    @Schema(description="Event body.", implementation=JsonNode.class)
    private transient JsonNode body;
    @JsonIgnore
    private byte[] bodyBytes;

    public EventInfo() {
    }

    public EventInfo(EventId id) {
        super(id);
    }

    public EventInfo(EventInfo event) {
        super(event);
        this.setBody(event.getBody());
    }

    public JsonNode getBody() {
        return BaseDataWithAdditionalInfo.getJson(() -> this.body, () -> this.bodyBytes);
    }

    public void setBody(JsonNode body) {
        BaseDataWithAdditionalInfo.setJson(body, json -> {
            this.body = json;
        }, bytes -> {
            this.bodyBytes = bytes;
        });
    }

    @Override
    @Schema(description="Timestamp of the event creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public byte[] getBodyBytes() {
        return this.bodyBytes;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setUid(String uid) {
        this.uid = uid;
    }

    @Generated
    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @JsonIgnore
    @Generated
    public void setBodyBytes(byte[] bodyBytes) {
        this.bodyBytes = bodyBytes;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventInfo)) {
            return false;
        }
        EventInfo other = (EventInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        return Arrays.equals(this.getBodyBytes(), other.getBodyBytes());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBodyBytes());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "EventInfo(tenantId=" + String.valueOf(this.getTenantId()) + ", type=" + this.getType() + ", uid=" + this.getUid() + ", entityId=" + String.valueOf(this.getEntityId()) + ", body=" + String.valueOf(this.getBody()) + ", bodyBytes=" + Arrays.toString(this.getBodyBytes()) + ")";
    }
}

