/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.objects.TelemetryEntityView;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class EntityView
extends BaseDataWithAdditionalInfo<EntityViewId>
implements GroupEntity<EntityViewId>,
ExportableEntity<EntityViewId>,
HasVersion {
    private static final long serialVersionUID = 5582010124562018986L;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="JSON object with the referenced Entity Id (Device or Asset).")
    private EntityId entityId;
    private TenantId tenantId;
    private CustomerId customerId;
    @NoXss
    @Length(fieldName="name")
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Entity View name", example="A4B72CCDFF33")
    private String name;
    @NoXss
    @Length(fieldName="type")
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Device Profile Name", example="Temperature Sensor")
    private String type;
    @Schema(description="Set of telemetry and attribute keys to expose via Entity View.")
    private TelemetryEntityView keys;
    @Schema(description="Represents the start time of the interval that is used to limit access to target device telemetry. Customer will not be able to see entity telemetry that is outside the specified interval;")
    private long startTimeMs;
    @Schema(description="Represents the end time of the interval that is used to limit access to target device telemetry. Customer will not be able to see entity telemetry that is outside the specified interval;")
    private long endTimeMs;
    private EntityViewId externalId;
    private Long version;

    public EntityView() {
    }

    public EntityView(EntityViewId id) {
        super(id);
    }

    public EntityView(EntityView entityView) {
        super(entityView);
        this.entityId = entityView.getEntityId();
        this.tenantId = entityView.getTenantId();
        this.customerId = entityView.getCustomerId();
        this.name = entityView.getName();
        this.type = entityView.getType();
        this.keys = entityView.getKeys();
        this.startTimeMs = entityView.getStartTimeMs();
        this.endTimeMs = entityView.getEndTimeMs();
        this.externalId = entityView.getExternalId();
        this.version = entityView.getVersion();
    }

    @Override
    @Schema(description="JSON object with Customer Id. Use 'assignEntityViewToCustomer' to change the Customer Id.", accessMode=Schema.AccessMode.READ_ONLY)
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Schema(description="JSON object with Tenant Id.", accessMode=Schema.AccessMode.READ_ONLY)
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Schema(description="JSON object with Customer or Tenant Id", accessMode=Schema.AccessMode.READ_ONLY)
    public EntityId getOwnerId() {
        return this.customerId != null && !this.customerId.isNullUid() ? this.customerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.customerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.ENTITY_VIEW;
    }

    @Override
    @Schema(description="JSON object with the Entity View Id. Specify this field to update the Entity View. Referencing non-existing Entity View Id will cause error. Omit this field to create new Entity View.")
    public EntityViewId getId() {
        return (EntityViewId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the Entity View creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Schema(description="Additional parameters of the device", implementation=JsonNode.class)
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public TelemetryEntityView getKeys() {
        return this.keys;
    }

    @Generated
    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    @Generated
    public long getEndTimeMs() {
        return this.endTimeMs;
    }

    @Override
    @Generated
    public EntityViewId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(CustomerId customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setKeys(TelemetryEntityView keys) {
        this.keys = keys;
    }

    @Generated
    public void setStartTimeMs(long startTimeMs) {
        this.startTimeMs = startTimeMs;
    }

    @Generated
    public void setEndTimeMs(long endTimeMs) {
        this.endTimeMs = endTimeMs;
    }

    @Override
    @Generated
    public void setExternalId(EntityViewId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    @Generated
    public String toString() {
        return "EntityView(entityId=" + String.valueOf(this.getEntityId()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", name=" + this.getName() + ", type=" + this.getType() + ", keys=" + String.valueOf(this.getKeys()) + ", startTimeMs=" + this.getStartTimeMs() + ", endTimeMs=" + this.getEndTimeMs() + ", externalId=" + String.valueOf(this.getExternalId()) + ", version=" + this.getVersion() + ")";
    }

    @ConstructorProperties(value={"entityId", "tenantId", "customerId", "name", "type", "keys", "startTimeMs", "endTimeMs", "externalId", "version"})
    @Generated
    public EntityView(EntityId entityId, TenantId tenantId, CustomerId customerId, String name, String type, TelemetryEntityView keys, long startTimeMs, long endTimeMs, EntityViewId externalId, Long version) {
        this.entityId = entityId;
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.name = name;
        this.type = type;
        this.keys = keys;
        this.startTimeMs = startTimeMs;
        this.endTimeMs = endTimeMs;
        this.externalId = externalId;
        this.version = version;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityView)) {
            return false;
        }
        EntityView other = (EntityView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getStartTimeMs() != other.getStartTimeMs()) {
            return false;
        }
        if (this.getEndTimeMs() != other.getEndTimeMs()) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$customerId = this.getCustomerId();
        CustomerId other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        TelemetryEntityView this$keys = this.getKeys();
        TelemetryEntityView other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        EntityViewId this$externalId = this.getExternalId();
        EntityViewId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityView;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $startTimeMs = this.getStartTimeMs();
        result = result * 59 + (int)($startTimeMs >>> 32 ^ $startTimeMs);
        long $endTimeMs = this.getEndTimeMs();
        result = result * 59 + (int)($endTimeMs >>> 32 ^ $endTimeMs);
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        TelemetryEntityView $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        EntityViewId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }
}

