/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EntityType {
    TENANT(1),
    CUSTOMER(2, true),
    USER(3, "tb_user", true),
    DASHBOARD(4, true),
    ASSET(5, true),
    DEVICE(6, true),
    ALARM(7),
    ENTITY_GROUP(100){

        @Override
        public String getNormalName() {
            return "Entity Group";
        }
    }
    ,
    CONVERTER(101),
    INTEGRATION(102),
    RULE_CHAIN(11),
    RULE_NODE(12),
    SCHEDULER_EVENT(103),
    BLOB_ENTITY(104),
    REPORT_TEMPLATE(108),
    REPORT(109),
    ENTITY_VIEW(15, true){

        @Override
        public String getNormalName() {
            return "Entity View";
        }
    }
    ,
    WIDGETS_BUNDLE(16),
    WIDGET_TYPE(17),
    ROLE(105),
    GROUP_PERMISSION(106),
    TENANT_PROFILE(20),
    DEVICE_PROFILE(21),
    ASSET_PROFILE(22),
    API_USAGE_STATE(23),
    TB_RESOURCE(24, "resource"),
    OTA_PACKAGE(25),
    EDGE(26, true),
    RPC(27),
    QUEUE(28),
    NOTIFICATION_TARGET(29),
    NOTIFICATION_TEMPLATE(30),
    NOTIFICATION_REQUEST(31),
    NOTIFICATION(32),
    NOTIFICATION_RULE(33),
    QUEUE_STATS(34),
    OAUTH2_CLIENT(35),
    DOMAIN(36),
    MOBILE_APP(37),
    MOBILE_APP_BUNDLE(38),
    CALCULATED_FIELD(39),
    CALCULATED_FIELD_LINK(40),
    JOB(41),
    SECRET(107),
    ADMIN_SETTINGS(42),
    AI_MODEL(43, "ai_model", false){

        @Override
        public String getNormalName() {
            return "AI model";
        }
    };

    private final int protoNumber;
    private final String tableName;
    private final boolean groupEntityType;
    private final String normalName = StringUtils.capitalize((String)StringUtils.removeStart((String)this.name(), (String)"TB_").toLowerCase().replaceAll("_", " "));
    public static final List<EntityType> GROUP_ENTITY_TYPES;
    public static final List<String> NORMAL_NAMES;
    private static final EntityType[] BY_PROTO;

    private EntityType(int protoNumber) {
        this(protoNumber, false);
    }

    private EntityType(int protoNumber, boolean groupEntityType) {
        this.protoNumber = protoNumber;
        this.groupEntityType = groupEntityType;
        this.tableName = this.name().toLowerCase();
    }

    private EntityType(int protoNumber, String tableName) {
        this(protoNumber, tableName, false);
    }

    private EntityType(int protoNumber, String tableName, boolean groupEntityType) {
        this.protoNumber = protoNumber;
        this.tableName = tableName;
        this.groupEntityType = groupEntityType;
    }

    public boolean isOneOf(EntityType ... types) {
        if (types == null) {
            return false;
        }
        for (EntityType type : types) {
            if (this != type) continue;
            return true;
        }
        return false;
    }

    public static EntityType forProtoNumber(int protoNumber) {
        if (protoNumber < 0 || protoNumber >= BY_PROTO.length) {
            throw new IllegalArgumentException("Invalid EntityType proto number " + protoNumber);
        }
        return BY_PROTO[protoNumber];
    }

    @Generated
    public int getProtoNumber() {
        return this.protoNumber;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public boolean isGroupEntityType() {
        return this.groupEntityType;
    }

    @Generated
    public String getNormalName() {
        return this.normalName;
    }

    static {
        GROUP_ENTITY_TYPES = EnumSet.allOf(EntityType.class).stream().filter(EntityType::isGroupEntityType).toList();
        NORMAL_NAMES = EnumSet.allOf(EntityType.class).stream().map(EntityType::getNormalName).toList();
        BY_PROTO = new EntityType[Arrays.stream(EntityType.values()).mapToInt(EntityType::getProtoNumber).max().orElse(0) + 1];
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        for (int i = 0; i < n; ++i) {
            EntityType entityType;
            EntityType.BY_PROTO[entityType.getProtoNumber()] = entityType = entityTypeArray[i];
        }
    }
}

