/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.HasId;

@Schema
public class EntityInfo
implements HasId<EntityId>,
HasName {
    @Schema(description="JSON object with the entity Id. ")
    private final EntityId id;
    @Schema(description="Entity Name")
    private final String name;

    @JsonCreator
    public EntityInfo(@JsonProperty(value="id") EntityId id, @JsonProperty(value="name") String name) {
        this.id = id;
        this.name = name;
    }

    public EntityInfo(UUID uuid, String entityType, String name) {
        this.id = EntityIdFactory.getByTypeAndUuid(entityType, uuid);
        this.name = name;
    }

    @Override
    @Generated
    public EntityId getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityInfo)) {
            return false;
        }
        EntityInfo other = (EntityInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityId this$id = this.getId();
        EntityId other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntityInfo(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ")";
    }
}

