/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Throwables;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;

public final class EdgeUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdgeUtils.class);
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("(\\$\\{\\{)(.*?)(}})");
    private static final String ATTRIBUTE_PLACEHOLDER_PATTERN = "${{%s}}";
    private static final String ATTRIBUTE_REGEXP_PLACEHOLDER_PATTERN = "\\$\\{\\{%s}}";
    private static final int STACK_TRACE_LIMIT = 10;
    private static final EnumMap<EntityType, EdgeEventType> entityTypeEdgeEventTypeEnumMap = new EnumMap(EntityType.class);
    private static final EnumMap<ActionType, EdgeEventActionType> actionTypeEdgeEventActionTypeEnumMap;

    private EdgeUtils() {
    }

    public static int nextPositiveInt() {
        return ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE);
    }

    public static EdgeEventType getEdgeEventTypeByEntityType(EntityType entityType) {
        return entityTypeEdgeEventTypeEnumMap.get((Object)entityType);
    }

    public static EdgeEventActionType getEdgeEventActionTypeByActionType(ActionType actionType) {
        return actionTypeEdgeEventActionTypeEnumMap.get((Object)actionType);
    }

    public static EdgeEvent constructEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body) {
        return EdgeUtils.constructEdgeEvent(tenantId, edgeId, type, action, entityId, body, null);
    }

    public static EdgeEvent constructEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body, EntityId entityGroupId) {
        EdgeEvent edgeEvent = new EdgeEvent();
        edgeEvent.setTenantId(tenantId);
        edgeEvent.setEdgeId(edgeId);
        edgeEvent.setType(type);
        edgeEvent.setAction(action);
        if (entityId != null) {
            edgeEvent.setEntityId(entityId.getId());
        }
        if (entityGroupId != null) {
            edgeEvent.setEntityGroupId(entityGroupId.getId());
        }
        edgeEvent.setBody(body);
        return edgeEvent;
    }

    public static Set<String> getAttributeKeysFromConfiguration(String integrationConfiguration) {
        HashSet<String> result = new HashSet<String>();
        Matcher m = ATTRIBUTE_PATTERN.matcher(integrationConfiguration);
        while (m.find()) {
            result.add(m.group(2));
        }
        return result;
    }

    public static String formatAttributeKeyToPlaceholderFormat(String attributeKey) {
        return String.format(ATTRIBUTE_PLACEHOLDER_PATTERN, attributeKey);
    }

    public static String formatAttributeKeyToRegexpPlaceholderFormat(String attributeKey) {
        return String.format(ATTRIBUTE_REGEXP_PLACEHOLDER_PATTERN, attributeKey);
    }

    public static String createErrorMsgFromRootCauseAndStackTrace(Throwable t) {
        Throwable rootCause = Throwables.getRootCause((Throwable)t);
        StringBuilder errorMsg = new StringBuilder(rootCause.getMessage() != null ? rootCause.getMessage() : "");
        if (rootCause.getStackTrace().length > 0) {
            int idx = 0;
            for (StackTraceElement stackTraceElement : rootCause.getStackTrace()) {
                errorMsg.append("\n").append(stackTraceElement.toString());
                if (++idx > 10) break;
            }
        }
        return errorMsg.toString();
    }

    public static boolean isEdgeGroupAll(String groupName) {
        if (groupName == null) {
            return false;
        }
        return groupName.startsWith("[Edge]") && groupName.endsWith("All");
    }

    public static String getEdgeGroupAllName(String edgeName) {
        return EdgeUtils.getEdgeGroupAllName(null, edgeName);
    }

    public static String getEdgeGroupAllName(String customerName, String edgeName) {
        if (customerName != null) {
            return String.format("[Edge][%s] %s All", customerName, edgeName);
        }
        return String.format("[Edge] %s All", edgeName);
    }

    static {
        for (EdgeEventType edgeEventType : EdgeEventType.values()) {
            if (edgeEventType.getEntityType() == null) continue;
            entityTypeEdgeEventTypeEnumMap.put(edgeEventType.getEntityType(), edgeEventType);
        }
        actionTypeEdgeEventActionTypeEnumMap = new EnumMap(ActionType.class);
        for (Enum enum_ : EdgeEventActionType.values()) {
            if (((EdgeEventActionType)enum_).getActionType() == null) continue;
            actionTypeEdgeEventActionTypeEnumMap.put(((EdgeEventActionType)enum_).getActionType(), (EdgeEventActionType)enum_);
        }
    }
}

