/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.github.os72.protobuf.dynamic.DynamicSchema;
import com.github.os72.protobuf.dynamic.EnumDefinition;
import com.github.os72.protobuf.dynamic.MessageDefinition;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.squareup.wire.Syntax;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import com.squareup.wire.schema.internal.parser.TypeElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.StringUtils;

public class DynamicProtoUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicProtoUtils.class);
    public static final Location LOCATION = new Location("", "", -1, -1);
    public static final String PROTO_3_SYNTAX = "proto3";

    public static Descriptors.Descriptor getDescriptor(String protoSchema, String schemaName) {
        try {
            DynamicMessage.Builder builder = DynamicProtoUtils.getDynamicMessageBuilder(protoSchema, schemaName);
            return builder.getDescriptorForType();
        }
        catch (Exception e) {
            log.warn("Failed to get Message Descriptor due to {}", (Object)e.getMessage());
            return null;
        }
    }

    public static DynamicMessage.Builder getDynamicMessageBuilder(String protoSchema, String schemaName) {
        ProtoFileElement protoFileElement = DynamicProtoUtils.getProtoFileElement(protoSchema);
        DynamicSchema dynamicSchema = DynamicProtoUtils.getDynamicSchema(protoFileElement, schemaName);
        String lastMsgName = DynamicProtoUtils.getMessageTypes(protoFileElement.getTypes()).stream().map(MessageElement::getName).reduce((previous, last) -> last).get();
        return dynamicSchema.newMessageBuilder(lastMsgName);
    }

    public static DynamicSchema getDynamicSchema(ProtoFileElement protoFileElement, String schemaName) {
        DynamicSchema.Builder schemaBuilder = DynamicSchema.newBuilder();
        schemaBuilder.setName(schemaName);
        schemaBuilder.setSyntax(PROTO_3_SYNTAX);
        schemaBuilder.setPackage(StringUtils.isNotEmpty(protoFileElement.getPackageName()) ? protoFileElement.getPackageName() : schemaName.toLowerCase());
        List types = protoFileElement.getTypes();
        List<MessageElement> messageTypes = DynamicProtoUtils.getMessageTypes(types);
        if (!messageTypes.isEmpty()) {
            List<EnumElement> enumTypes = DynamicProtoUtils.getEnumElements(types);
            if (!enumTypes.isEmpty()) {
                enumTypes.forEach(enumElement -> {
                    EnumDefinition enumDefinition = DynamicProtoUtils.getEnumDefinition(enumElement);
                    schemaBuilder.addEnumDefinition(enumDefinition);
                });
            }
            List<MessageDefinition> messageDefinitions = DynamicProtoUtils.getMessageDefinitions(messageTypes);
            messageDefinitions.forEach(arg_0 -> ((DynamicSchema.Builder)schemaBuilder).addMessageDefinition(arg_0));
            try {
                return schemaBuilder.build();
            }
            catch (Descriptors.DescriptorValidationException e) {
                throw new RuntimeException("Failed to create dynamic schema due to: " + e.getMessage());
            }
        }
        throw new RuntimeException("Failed to get Dynamic Schema! Message types is empty for schema:" + schemaName);
    }

    public static ProtoFileElement getProtoFileElement(String protoSchema) {
        return new ProtoParser(LOCATION, protoSchema.toCharArray()).readProtoFile();
    }

    public static String dynamicMsgToJson(Descriptors.Descriptor descriptor, byte[] payload) throws InvalidProtocolBufferException {
        DynamicMessage dynamicMessage = DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (byte[])payload);
        return JsonFormat.printer().includingDefaultValueFields().print((MessageOrBuilder)dynamicMessage);
    }

    public static DynamicMessage jsonToDynamicMessage(DynamicMessage.Builder builder, String payload) throws InvalidProtocolBufferException {
        JsonFormat.parser().ignoringUnknownFields().merge(payload, (Message.Builder)builder);
        return builder.build();
    }

    private static List<MessageElement> getMessageTypes(List<TypeElement> types) {
        return types.stream().filter(typeElement -> typeElement instanceof MessageElement).map(typeElement -> (MessageElement)typeElement).collect(Collectors.toList());
    }

    private static List<EnumElement> getEnumElements(List<TypeElement> types) {
        return types.stream().filter(typeElement -> typeElement instanceof EnumElement).map(typeElement -> (EnumElement)typeElement).collect(Collectors.toList());
    }

    private static List<MessageDefinition> getMessageDefinitions(List<MessageElement> messageElementsList) {
        if (!messageElementsList.isEmpty()) {
            ArrayList<MessageDefinition> messageDefinitions = new ArrayList<MessageDefinition>();
            messageElementsList.forEach(messageElement -> {
                MessageDefinition.Builder messageDefinitionBuilder = MessageDefinition.newBuilder((String)messageElement.getName());
                List nestedTypes = messageElement.getNestedTypes();
                if (!nestedTypes.isEmpty()) {
                    List<EnumElement> nestedEnumTypes = DynamicProtoUtils.getEnumElements(nestedTypes);
                    if (!nestedEnumTypes.isEmpty()) {
                        nestedEnumTypes.forEach(enumElement -> {
                            EnumDefinition nestedEnumDefinition = DynamicProtoUtils.getEnumDefinition(enumElement);
                            messageDefinitionBuilder.addEnumDefinition(nestedEnumDefinition);
                        });
                    }
                    List<MessageElement> nestedMessageTypes = DynamicProtoUtils.getMessageTypes(nestedTypes);
                    List<MessageDefinition> nestedMessageDefinitions = DynamicProtoUtils.getMessageDefinitions(nestedMessageTypes);
                    nestedMessageDefinitions.forEach(arg_0 -> ((MessageDefinition.Builder)messageDefinitionBuilder).addMessageDefinition(arg_0));
                }
                List messageElementFields = messageElement.getFields();
                List oneOfs = messageElement.getOneOfs();
                if (!oneOfs.isEmpty()) {
                    for (OneOfElement oneOfelement : oneOfs) {
                        MessageDefinition.OneofBuilder oneofBuilder = messageDefinitionBuilder.addOneof(oneOfelement.getName());
                        DynamicProtoUtils.addMessageFieldsToTheOneOfDefinition(oneOfelement.getFields(), oneofBuilder);
                    }
                }
                if (!messageElementFields.isEmpty()) {
                    DynamicProtoUtils.addMessageFieldsToTheMessageDefinition(messageElementFields, messageDefinitionBuilder);
                }
                messageDefinitions.add(messageDefinitionBuilder.build());
            });
            return messageDefinitions;
        }
        return Collections.emptyList();
    }

    private static EnumDefinition getEnumDefinition(EnumElement enumElement) {
        List enumElementTypeConstants = enumElement.getConstants();
        EnumDefinition.Builder enumDefinitionBuilder = EnumDefinition.newBuilder((String)enumElement.getName());
        if (!enumElementTypeConstants.isEmpty()) {
            enumElementTypeConstants.forEach(constantElement -> enumDefinitionBuilder.addValue(constantElement.getName(), constantElement.getTag()));
        }
        return enumDefinitionBuilder.build();
    }

    private static void addMessageFieldsToTheMessageDefinition(List<FieldElement> messageElementFields, MessageDefinition.Builder messageDefinitionBuilder) {
        messageElementFields.forEach(fieldElement -> {
            String labelStr = null;
            if (fieldElement.getLabel() != null) {
                labelStr = fieldElement.getLabel().name().toLowerCase();
            }
            messageDefinitionBuilder.addField(labelStr, fieldElement.getType(), fieldElement.getName(), fieldElement.getTag());
        });
    }

    private static void addMessageFieldsToTheOneOfDefinition(List<FieldElement> oneOfsElementFields, MessageDefinition.OneofBuilder oneofBuilder) {
        oneOfsElementFields.forEach(fieldElement -> oneofBuilder.addField(fieldElement.getType(), fieldElement.getName(), fieldElement.getTag()));
        oneofBuilder.msgDefBuilder();
    }

    public static void validateProtoSchema(String schema, String schemaName, String exceptionPrefix) throws IllegalArgumentException {
        ProtoFileElement protoFileElement;
        ProtoParser schemaParser = new ProtoParser(LOCATION, schema.toCharArray());
        try {
            protoFileElement = schemaParser.readProtoFile();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(exceptionPrefix + " failed to parse " + schemaName + " due to: " + e.getMessage());
        }
        DynamicProtoUtils.checkProtoFileSyntax(schemaName, protoFileElement);
        DynamicProtoUtils.checkProtoFileCommonSettings(schemaName, protoFileElement.getOptions().isEmpty(), " Schema options don't support!", exceptionPrefix);
        DynamicProtoUtils.checkProtoFileCommonSettings(schemaName, protoFileElement.getPublicImports().isEmpty(), " Schema public imports don't support!", exceptionPrefix);
        DynamicProtoUtils.checkProtoFileCommonSettings(schemaName, protoFileElement.getImports().isEmpty(), " Schema imports don't support!", exceptionPrefix);
        DynamicProtoUtils.checkProtoFileCommonSettings(schemaName, protoFileElement.getExtendDeclarations().isEmpty(), " Schema extend declarations don't support!", exceptionPrefix);
        DynamicProtoUtils.checkTypeElements(schemaName, protoFileElement, exceptionPrefix);
    }

    private static void checkProtoFileSyntax(String schemaName, ProtoFileElement protoFileElement) {
        if (protoFileElement.getSyntax() == null || !protoFileElement.getSyntax().equals((Object)Syntax.PROTO_3)) {
            throw new IllegalArgumentException("[Transport Configuration] invalid schema syntax: " + String.valueOf(protoFileElement.getSyntax()) + " for " + schemaName + " provided! Only " + String.valueOf(Syntax.PROTO_3) + " allowed!");
        }
    }

    private static void checkProtoFileCommonSettings(String schemaName, boolean isEmptySettings, String invalidSettingsMessage, String exceptionPrefix) {
        if (!isEmptySettings) {
            throw new IllegalArgumentException(DynamicProtoUtils.invalidSchemaProvidedMessage(schemaName, exceptionPrefix) + invalidSettingsMessage);
        }
    }

    private static void checkTypeElements(String schemaName, ProtoFileElement protoFileElement, String exceptionPrefix) {
        List types = protoFileElement.getTypes();
        if (!types.isEmpty()) {
            if (types.stream().noneMatch(typeElement -> typeElement instanceof MessageElement)) {
                throw new IllegalArgumentException(DynamicProtoUtils.invalidSchemaProvidedMessage(schemaName, exceptionPrefix) + " At least one Message definition should exists!");
            }
        } else {
            throw new IllegalArgumentException(DynamicProtoUtils.invalidSchemaProvidedMessage(schemaName, exceptionPrefix) + " Type elements is empty!");
        }
        DynamicProtoUtils.checkEnumElements(schemaName, DynamicProtoUtils.getEnumElements(types), exceptionPrefix);
        DynamicProtoUtils.checkMessageElements(schemaName, DynamicProtoUtils.getMessageTypes(types), exceptionPrefix);
    }

    private static void checkFieldElements(String schemaName, List<FieldElement> fieldElements, String exceptionPrefix) {
        if (!fieldElements.isEmpty()) {
            boolean hasRequiredLabel = fieldElements.stream().anyMatch(fieldElement -> {
                Field.Label label = fieldElement.getLabel();
                return label != null && label.equals((Object)Field.Label.REQUIRED);
            });
            if (hasRequiredLabel) {
                throw new IllegalArgumentException(DynamicProtoUtils.invalidSchemaProvidedMessage(schemaName, exceptionPrefix) + " Required labels are not supported!");
            }
            boolean hasDefaultValue = fieldElements.stream().anyMatch(fieldElement -> fieldElement.getDefaultValue() != null);
            if (hasDefaultValue) {
                throw new IllegalArgumentException(DynamicProtoUtils.invalidSchemaProvidedMessage(schemaName, exceptionPrefix) + " Default values are not supported!");
            }
        }
    }

    private static void checkEnumElements(String schemaName, List<EnumElement> enumTypes, String exceptionPrefix) {
        if (enumTypes.stream().anyMatch(enumElement -> !enumElement.getNestedTypes().isEmpty())) {
            throw new IllegalArgumentException(DynamicProtoUtils.invalidSchemaProvidedMessage(schemaName, exceptionPrefix) + " Nested types in Enum definitions are not supported!");
        }
        if (enumTypes.stream().anyMatch(enumElement -> !enumElement.getOptions().isEmpty())) {
            throw new IllegalArgumentException(DynamicProtoUtils.invalidSchemaProvidedMessage(schemaName, exceptionPrefix) + " Enum definitions options are not supported!");
        }
    }

    private static void checkMessageElements(String schemaName, List<MessageElement> messageElementsList, String exceptionPrefix) {
        if (!messageElementsList.isEmpty()) {
            messageElementsList.forEach(messageElement -> {
                List nestedTypes;
                DynamicProtoUtils.checkProtoFileCommonSettings(schemaName, messageElement.getGroups().isEmpty(), " Message definition groups don't support!", exceptionPrefix);
                DynamicProtoUtils.checkProtoFileCommonSettings(schemaName, messageElement.getOptions().isEmpty(), " Message definition options don't support!", exceptionPrefix);
                DynamicProtoUtils.checkProtoFileCommonSettings(schemaName, messageElement.getExtensions().isEmpty(), " Message definition extensions don't support!", exceptionPrefix);
                DynamicProtoUtils.checkProtoFileCommonSettings(schemaName, messageElement.getReserveds().isEmpty(), " Message definition reserved elements don't support!", exceptionPrefix);
                DynamicProtoUtils.checkFieldElements(schemaName, messageElement.getFields(), exceptionPrefix);
                List oneOfs = messageElement.getOneOfs();
                if (!oneOfs.isEmpty()) {
                    oneOfs.forEach(oneOfElement -> {
                        DynamicProtoUtils.checkProtoFileCommonSettings(schemaName, oneOfElement.getGroups().isEmpty(), " OneOf definition groups don't support!", exceptionPrefix);
                        DynamicProtoUtils.checkFieldElements(schemaName, oneOfElement.getFields(), exceptionPrefix);
                    });
                }
                if (!(nestedTypes = messageElement.getNestedTypes()).isEmpty()) {
                    List<EnumElement> nestedEnumTypes = DynamicProtoUtils.getEnumElements(nestedTypes);
                    if (!nestedEnumTypes.isEmpty()) {
                        DynamicProtoUtils.checkEnumElements(schemaName, nestedEnumTypes, exceptionPrefix);
                    }
                    List<MessageElement> nestedMessageTypes = DynamicProtoUtils.getMessageTypes(nestedTypes);
                    DynamicProtoUtils.checkMessageElements(schemaName, nestedMessageTypes, exceptionPrefix);
                }
            });
        }
    }

    public static String invalidSchemaProvidedMessage(String schemaName, String exceptionPrefix) {
        return exceptionPrefix + " invalid " + schemaName + " provided!";
    }
}

