/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceProfileType;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.EntityInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;

public final class DeviceProfileInfo
extends EntityInfo {
    @Schema(description="Either URL or Base64 data of the icon. Used in the mobile application to visualize set of device profiles in the grid view. ")
    private final String image;
    @Schema(description="Reference to the dashboard. Used in the mobile application to open the default dashboard when user navigates to device details.")
    private final DashboardId defaultDashboardId;
    @Schema(description="Type of the profile. Always 'DEFAULT' for now. Reserved for future use.")
    private final DeviceProfileType type;
    @Schema(description="Type of the transport used to connect the device. Default transport supports HTTP, CoAP and MQTT.")
    private final DeviceTransportType transportType;
    @Schema(description="Tenant id.")
    private final TenantId tenantId;

    @JsonCreator
    public DeviceProfileInfo(@JsonProperty(value="id") EntityId id, @JsonProperty(value="tenantId") TenantId tenantId, @JsonProperty(value="name") String name, @JsonProperty(value="image") String image, @JsonProperty(value="defaultDashboardId") DashboardId defaultDashboardId, @JsonProperty(value="type") DeviceProfileType type, @JsonProperty(value="transportType") DeviceTransportType transportType) {
        super(id, name);
        this.tenantId = tenantId;
        this.image = image;
        this.defaultDashboardId = defaultDashboardId;
        this.type = type;
        this.transportType = transportType;
    }

    public DeviceProfileInfo(UUID uuid, UUID tenantId, String name, String image, UUID defaultDashboardId, DeviceProfileType type, DeviceTransportType transportType) {
        super(EntityIdFactory.getByTypeAndUuid(EntityType.DEVICE_PROFILE, uuid), name);
        this.tenantId = TenantId.fromUUID(tenantId);
        this.image = image;
        this.defaultDashboardId = defaultDashboardId != null ? new DashboardId(defaultDashboardId) : null;
        this.type = type;
        this.transportType = transportType;
    }

    public DeviceProfileInfo(DeviceProfile profile) {
        this(profile.getId(), profile.getTenantId(), profile.getName(), profile.getImage(), profile.getDefaultDashboardId(), profile.getType(), profile.getTransportType());
    }

    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public DashboardId getDefaultDashboardId() {
        return this.defaultDashboardId;
    }

    @Generated
    public DeviceProfileType getType() {
        return this.type;
    }

    @Generated
    public DeviceTransportType getTransportType() {
        return this.transportType;
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceProfileInfo)) {
            return false;
        }
        DeviceProfileInfo other = (DeviceProfileInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        DashboardId this$defaultDashboardId = this.getDefaultDashboardId();
        DashboardId other$defaultDashboardId = other.getDefaultDashboardId();
        if (this$defaultDashboardId == null ? other$defaultDashboardId != null : !((Object)this$defaultDashboardId).equals(other$defaultDashboardId)) {
            return false;
        }
        DeviceProfileType this$type = this.getType();
        DeviceProfileType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        DeviceTransportType this$transportType = this.getTransportType();
        DeviceTransportType other$transportType = other.getTransportType();
        if (this$transportType == null ? other$transportType != null : !((Object)((Object)this$transportType)).equals((Object)other$transportType)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeviceProfileInfo;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        DashboardId $defaultDashboardId = this.getDefaultDashboardId();
        result = result * 59 + ($defaultDashboardId == null ? 43 : ((Object)$defaultDashboardId).hashCode());
        DeviceProfileType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        DeviceTransportType $transportType = this.getTransportType();
        result = result * 59 + ($transportType == null ? 43 : ((Object)((Object)$transportType)).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DeviceProfileInfo(super=" + super.toString() + ", defaultDashboardId=" + String.valueOf(this.getDefaultDashboardId()) + ", type=" + String.valueOf((Object)this.getType()) + ", transportType=" + String.valueOf((Object)this.getTransportType()) + ", tenantId=" + String.valueOf(this.getTenantId()) + ")";
    }
}

