/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.ContactBased;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.GroupEntity;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.HasTitle;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.ShortCustomerInfo;
import org.thingsboard.server.common.data.id.CustomMenuId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class Customer
extends ContactBased<CustomerId>
implements HasTenantId,
HasTitle,
GroupEntity<CustomerId>,
ExportableEntity<CustomerId>,
HasVersion {
    private static final long serialVersionUID = -1599722990298929275L;
    @NoXss
    @Length(fieldName="title")
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Title of the customer", example="Company A")
    private String title;
    @Schema(description="JSON object with Tenant Id")
    private TenantId tenantId;
    @Schema(description="JSON object with parent Customer Id")
    private CustomerId parentCustomerId;
    private CustomerId externalId;
    private Long version;
    private CustomMenuId customMenuId;

    public Customer() {
    }

    public Customer(CustomerId id) {
        super(id);
    }

    public Customer(Customer customer) {
        super(customer);
        this.tenantId = customer.getTenantId();
        this.parentCustomerId = customer.getParentCustomerId();
        this.title = customer.getTitle();
        this.externalId = customer.getExternalId();
        this.version = customer.getVersion();
        this.customMenuId = customer.getCustomMenuId();
    }

    @Override
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    public CustomerId getParentCustomerId() {
        return this.parentCustomerId;
    }

    public void setParentCustomerId(CustomerId parentCustomerId) {
        this.parentCustomerId = parentCustomerId;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, description="JSON object with parent Customer Id")
    public CustomerId getCustomerId() {
        return this.parentCustomerId;
    }

    @Override
    @Schema(description="JSON object with Customer or Tenant Id", accessMode=Schema.AccessMode.READ_ONLY)
    public EntityId getOwnerId() {
        return this.parentCustomerId != null && !this.parentCustomerId.isNullUid() ? this.parentCustomerId : this.tenantId;
    }

    @Override
    public void setOwnerId(EntityId entityId) {
        this.parentCustomerId = EntityType.CUSTOMER.equals((Object)entityId.getEntityType()) ? new CustomerId(entityId.getId()) : new CustomerId(CustomerId.NULL_UUID);
    }

    @JsonIgnore
    public boolean isSubCustomer() {
        return this.parentCustomerId != null && !this.parentCustomerId.isNullUid();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    @Schema(description="JSON object with the customer Id. Specify this field to update the customer. Referencing non-existing customer Id will cause error. Omit this field to create new customer.")
    public CustomerId getId() {
        return (CustomerId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the customer creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Schema(description="Country", example="US")
    public String getCountry() {
        return super.getCountry();
    }

    @Override
    @Schema(description="State", example="NY")
    public String getState() {
        return super.getState();
    }

    @Override
    @Schema(description="City", example="New York")
    public String getCity() {
        return super.getCity();
    }

    @Override
    @Schema(description="Address Line 1", example="42 Broadway Suite 12-400")
    public String getAddress() {
        return super.getAddress();
    }

    @Override
    @Schema(description="Address Line 2", example="")
    public String getAddress2() {
        return super.getAddress2();
    }

    @Override
    @Schema(description="Zip code", example="10004")
    public String getZip() {
        return super.getZip();
    }

    @Override
    @Schema(description="Phone number", example="+1(415)777-7777")
    public String getPhone() {
        return super.getPhone();
    }

    @Override
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Email", example="example@company.com")
    public String getEmail() {
        return super.getEmail();
    }

    @Override
    @Schema(description="Additional parameters of the device", implementation=JsonNode.class)
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @JsonIgnore
    public boolean isPublic() {
        if (this.getAdditionalInfo() != null && this.getAdditionalInfo().has("isPublic")) {
            return this.getAdditionalInfo().get("isPublic").asBoolean();
        }
        return false;
    }

    @JsonIgnore
    public ShortCustomerInfo toShortCustomerInfo() {
        return new ShortCustomerInfo((CustomerId)this.id, this.title, this.isPublic());
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Schema(description="Name of the customer. Read-only, duplicated from title for backward compatibility", example="Company A", accessMode=Schema.AccessMode.READ_ONLY)
    public String getName() {
        return this.title;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Customer [title=");
        builder.append(this.title);
        builder.append(", tenantId=");
        builder.append(this.tenantId);
        builder.append(", additionalInfo=");
        builder.append(this.getAdditionalInfo());
        builder.append(", country=");
        builder.append(this.country);
        builder.append(", state=");
        builder.append(this.state);
        builder.append(", city=");
        builder.append(this.city);
        builder.append(", address=");
        builder.append(this.address);
        builder.append(", address2=");
        builder.append(this.address2);
        builder.append(", zip=");
        builder.append(this.zip);
        builder.append(", phone=");
        builder.append(this.phone);
        builder.append(", email=");
        builder.append(this.email);
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.CUSTOMER;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Customer)) {
            return false;
        }
        Customer other = (Customer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        CustomerId this$parentCustomerId = this.getParentCustomerId();
        CustomerId other$parentCustomerId = other.getParentCustomerId();
        if (this$parentCustomerId == null ? other$parentCustomerId != null : !((Object)this$parentCustomerId).equals(other$parentCustomerId)) {
            return false;
        }
        CustomerId this$externalId = this.getExternalId();
        CustomerId other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId)) {
            return false;
        }
        CustomMenuId this$customMenuId = this.getCustomMenuId();
        CustomMenuId other$customMenuId = other.getCustomMenuId();
        return !(this$customMenuId == null ? other$customMenuId != null : !((Object)this$customMenuId).equals(other$customMenuId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Customer;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        CustomerId $parentCustomerId = this.getParentCustomerId();
        result = result * 59 + ($parentCustomerId == null ? 43 : ((Object)$parentCustomerId).hashCode());
        CustomerId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        CustomMenuId $customMenuId = this.getCustomMenuId();
        result = result * 59 + ($customMenuId == null ? 43 : ((Object)$customMenuId).hashCode());
        return result;
    }

    @Override
    @Generated
    public CustomerId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public void setExternalId(CustomerId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public CustomMenuId getCustomMenuId() {
        return this.customMenuId;
    }

    @Generated
    public void setCustomMenuId(CustomMenuId customMenuId) {
        this.customMenuId = customMenuId;
    }
}

