/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Generated;
import org.thingsboard.server.common.data.ApiUsageStateValue;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.TenantEntity;
import org.thingsboard.server.common.data.id.ApiUsageStateId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;

public class ApiUsageState
extends BaseData<ApiUsageStateId>
implements TenantEntity,
HasVersion {
    private static final long serialVersionUID = 8250339805336035966L;
    private TenantId tenantId;
    private EntityId entityId;
    private ApiUsageStateValue transportState;
    private ApiUsageStateValue dbStorageState;
    private ApiUsageStateValue reExecState;
    private ApiUsageStateValue jsExecState;
    private ApiUsageStateValue tbelExecState;
    private ApiUsageStateValue emailExecState;
    private ApiUsageStateValue smsExecState;
    private ApiUsageStateValue alarmExecState;
    private ApiUsageStateValue reportExecState;
    private Long version;

    public ApiUsageState() {
    }

    public ApiUsageState(ApiUsageStateId id) {
        super(id);
    }

    public ApiUsageState(ApiUsageState ur) {
        super(ur);
        this.tenantId = ur.getTenantId();
        this.entityId = ur.getEntityId();
        this.transportState = ur.getTransportState();
        this.dbStorageState = ur.getDbStorageState();
        this.reExecState = ur.getReExecState();
        this.jsExecState = ur.getJsExecState();
        this.tbelExecState = ur.getTbelExecState();
        this.emailExecState = ur.getEmailExecState();
        this.smsExecState = ur.getSmsExecState();
        this.alarmExecState = ur.getAlarmExecState();
        this.reportExecState = ur.getReportExecState();
        this.version = ur.getVersion();
    }

    public boolean isTransportEnabled() {
        return !ApiUsageStateValue.DISABLED.equals((Object)this.transportState);
    }

    public boolean isReExecEnabled() {
        return !ApiUsageStateValue.DISABLED.equals((Object)this.reExecState);
    }

    public boolean isDbStorageEnabled() {
        return !ApiUsageStateValue.DISABLED.equals((Object)this.dbStorageState);
    }

    public boolean isJsExecEnabled() {
        return !ApiUsageStateValue.DISABLED.equals((Object)this.jsExecState);
    }

    public boolean isTbelExecEnabled() {
        return !ApiUsageStateValue.DISABLED.equals((Object)this.tbelExecState);
    }

    public boolean isEmailSendEnabled() {
        return !ApiUsageStateValue.DISABLED.equals((Object)this.emailExecState);
    }

    public boolean isSmsSendEnabled() {
        return !ApiUsageStateValue.DISABLED.equals((Object)this.smsExecState);
    }

    public boolean isAlarmCreationEnabled() {
        return this.alarmExecState != ApiUsageStateValue.DISABLED;
    }

    public boolean isReportCreationEnabled() {
        return this.reportExecState != ApiUsageStateValue.DISABLED;
    }

    @Override
    @JsonIgnore
    public EntityType getEntityType() {
        return EntityType.API_USAGE_STATE;
    }

    @Override
    @Generated
    public String toString() {
        return "ApiUsageState(tenantId=" + String.valueOf(this.getTenantId()) + ", entityId=" + String.valueOf(this.getEntityId()) + ", transportState=" + String.valueOf((Object)this.getTransportState()) + ", dbStorageState=" + String.valueOf((Object)this.getDbStorageState()) + ", reExecState=" + String.valueOf((Object)this.getReExecState()) + ", jsExecState=" + String.valueOf((Object)this.getJsExecState()) + ", tbelExecState=" + String.valueOf((Object)this.getTbelExecState()) + ", emailExecState=" + String.valueOf((Object)this.getEmailExecState()) + ", smsExecState=" + String.valueOf((Object)this.getSmsExecState()) + ", alarmExecState=" + String.valueOf((Object)this.getAlarmExecState()) + ", reportExecState=" + String.valueOf((Object)this.getReportExecState()) + ", version=" + this.getVersion() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiUsageState)) {
            return false;
        }
        ApiUsageState other = (ApiUsageState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        ApiUsageStateValue this$transportState = this.getTransportState();
        ApiUsageStateValue other$transportState = other.getTransportState();
        if (this$transportState == null ? other$transportState != null : !((Object)((Object)this$transportState)).equals((Object)other$transportState)) {
            return false;
        }
        ApiUsageStateValue this$dbStorageState = this.getDbStorageState();
        ApiUsageStateValue other$dbStorageState = other.getDbStorageState();
        if (this$dbStorageState == null ? other$dbStorageState != null : !((Object)((Object)this$dbStorageState)).equals((Object)other$dbStorageState)) {
            return false;
        }
        ApiUsageStateValue this$reExecState = this.getReExecState();
        ApiUsageStateValue other$reExecState = other.getReExecState();
        if (this$reExecState == null ? other$reExecState != null : !((Object)((Object)this$reExecState)).equals((Object)other$reExecState)) {
            return false;
        }
        ApiUsageStateValue this$jsExecState = this.getJsExecState();
        ApiUsageStateValue other$jsExecState = other.getJsExecState();
        if (this$jsExecState == null ? other$jsExecState != null : !((Object)((Object)this$jsExecState)).equals((Object)other$jsExecState)) {
            return false;
        }
        ApiUsageStateValue this$tbelExecState = this.getTbelExecState();
        ApiUsageStateValue other$tbelExecState = other.getTbelExecState();
        if (this$tbelExecState == null ? other$tbelExecState != null : !((Object)((Object)this$tbelExecState)).equals((Object)other$tbelExecState)) {
            return false;
        }
        ApiUsageStateValue this$emailExecState = this.getEmailExecState();
        ApiUsageStateValue other$emailExecState = other.getEmailExecState();
        if (this$emailExecState == null ? other$emailExecState != null : !((Object)((Object)this$emailExecState)).equals((Object)other$emailExecState)) {
            return false;
        }
        ApiUsageStateValue this$smsExecState = this.getSmsExecState();
        ApiUsageStateValue other$smsExecState = other.getSmsExecState();
        if (this$smsExecState == null ? other$smsExecState != null : !((Object)((Object)this$smsExecState)).equals((Object)other$smsExecState)) {
            return false;
        }
        ApiUsageStateValue this$alarmExecState = this.getAlarmExecState();
        ApiUsageStateValue other$alarmExecState = other.getAlarmExecState();
        if (this$alarmExecState == null ? other$alarmExecState != null : !((Object)((Object)this$alarmExecState)).equals((Object)other$alarmExecState)) {
            return false;
        }
        ApiUsageStateValue this$reportExecState = this.getReportExecState();
        ApiUsageStateValue other$reportExecState = other.getReportExecState();
        return !(this$reportExecState == null ? other$reportExecState != null : !((Object)((Object)this$reportExecState)).equals((Object)other$reportExecState));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiUsageState;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        ApiUsageStateValue $transportState = this.getTransportState();
        result = result * 59 + ($transportState == null ? 43 : ((Object)((Object)$transportState)).hashCode());
        ApiUsageStateValue $dbStorageState = this.getDbStorageState();
        result = result * 59 + ($dbStorageState == null ? 43 : ((Object)((Object)$dbStorageState)).hashCode());
        ApiUsageStateValue $reExecState = this.getReExecState();
        result = result * 59 + ($reExecState == null ? 43 : ((Object)((Object)$reExecState)).hashCode());
        ApiUsageStateValue $jsExecState = this.getJsExecState();
        result = result * 59 + ($jsExecState == null ? 43 : ((Object)((Object)$jsExecState)).hashCode());
        ApiUsageStateValue $tbelExecState = this.getTbelExecState();
        result = result * 59 + ($tbelExecState == null ? 43 : ((Object)((Object)$tbelExecState)).hashCode());
        ApiUsageStateValue $emailExecState = this.getEmailExecState();
        result = result * 59 + ($emailExecState == null ? 43 : ((Object)((Object)$emailExecState)).hashCode());
        ApiUsageStateValue $smsExecState = this.getSmsExecState();
        result = result * 59 + ($smsExecState == null ? 43 : ((Object)((Object)$smsExecState)).hashCode());
        ApiUsageStateValue $alarmExecState = this.getAlarmExecState();
        result = result * 59 + ($alarmExecState == null ? 43 : ((Object)((Object)$alarmExecState)).hashCode());
        ApiUsageStateValue $reportExecState = this.getReportExecState();
        result = result * 59 + ($reportExecState == null ? 43 : ((Object)((Object)$reportExecState)).hashCode());
        return result;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public ApiUsageStateValue getTransportState() {
        return this.transportState;
    }

    @Generated
    public ApiUsageStateValue getDbStorageState() {
        return this.dbStorageState;
    }

    @Generated
    public ApiUsageStateValue getReExecState() {
        return this.reExecState;
    }

    @Generated
    public ApiUsageStateValue getJsExecState() {
        return this.jsExecState;
    }

    @Generated
    public ApiUsageStateValue getTbelExecState() {
        return this.tbelExecState;
    }

    @Generated
    public ApiUsageStateValue getEmailExecState() {
        return this.emailExecState;
    }

    @Generated
    public ApiUsageStateValue getSmsExecState() {
        return this.smsExecState;
    }

    @Generated
    public ApiUsageStateValue getAlarmExecState() {
        return this.alarmExecState;
    }

    @Generated
    public ApiUsageStateValue getReportExecState() {
        return this.reportExecState;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setTransportState(ApiUsageStateValue transportState) {
        this.transportState = transportState;
    }

    @Generated
    public void setDbStorageState(ApiUsageStateValue dbStorageState) {
        this.dbStorageState = dbStorageState;
    }

    @Generated
    public void setReExecState(ApiUsageStateValue reExecState) {
        this.reExecState = reExecState;
    }

    @Generated
    public void setJsExecState(ApiUsageStateValue jsExecState) {
        this.jsExecState = jsExecState;
    }

    @Generated
    public void setTbelExecState(ApiUsageStateValue tbelExecState) {
        this.tbelExecState = tbelExecState;
    }

    @Generated
    public void setEmailExecState(ApiUsageStateValue emailExecState) {
        this.emailExecState = emailExecState;
    }

    @Generated
    public void setSmsExecState(ApiUsageStateValue smsExecState) {
        this.smsExecState = smsExecState;
    }

    @Generated
    public void setAlarmExecState(ApiUsageStateValue alarmExecState) {
        this.alarmExecState = alarmExecState;
    }

    @Generated
    public void setReportExecState(ApiUsageStateValue reportExecState) {
        this.reportExecState = reportExecState;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }
}

