/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import lombok.Generated;
import org.thingsboard.server.common.data.ApiFeature;
import org.thingsboard.server.common.data.ApiUsageRecordKey;

public class ApiUsageRecordState
implements Serializable {
    private final ApiFeature apiFeature;
    private final ApiUsageRecordKey key;
    private final long threshold;
    private final long value;

    public String getValueAsString() {
        return this.valueAsString(this.value);
    }

    public String getThresholdAsString() {
        return this.valueAsString(this.threshold);
    }

    private String valueAsString(long value) {
        if (value > 1000000L && value % 1000000L < 10000L) {
            return value / 1000000L + "M";
        }
        if (value > 10000L) {
            return String.format("%.2fM", (double)value / 1000000.0);
        }
        return "" + value;
    }

    @ConstructorProperties(value={"apiFeature", "key", "threshold", "value"})
    @Generated
    public ApiUsageRecordState(ApiFeature apiFeature, ApiUsageRecordKey key, long threshold, long value) {
        this.apiFeature = apiFeature;
        this.key = key;
        this.threshold = threshold;
        this.value = value;
    }

    @Generated
    public ApiFeature getApiFeature() {
        return this.apiFeature;
    }

    @Generated
    public ApiUsageRecordKey getKey() {
        return this.key;
    }

    @Generated
    public long getThreshold() {
        return this.threshold;
    }

    @Generated
    public long getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiUsageRecordState)) {
            return false;
        }
        ApiUsageRecordState other = (ApiUsageRecordState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getThreshold() != other.getThreshold()) {
            return false;
        }
        if (this.getValue() != other.getValue()) {
            return false;
        }
        ApiFeature this$apiFeature = this.getApiFeature();
        ApiFeature other$apiFeature = other.getApiFeature();
        if (this$apiFeature == null ? other$apiFeature != null : !((Object)((Object)this$apiFeature)).equals((Object)other$apiFeature)) {
            return false;
        }
        ApiUsageRecordKey this$key = this.getKey();
        ApiUsageRecordKey other$key = other.getKey();
        return !(this$key == null ? other$key != null : !((Object)((Object)this$key)).equals((Object)other$key));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiUsageRecordState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $threshold = this.getThreshold();
        result = result * 59 + (int)($threshold >>> 32 ^ $threshold);
        long $value = this.getValue();
        result = result * 59 + (int)($value >>> 32 ^ $value);
        ApiFeature $apiFeature = this.getApiFeature();
        result = result * 59 + ($apiFeature == null ? 43 : ((Object)((Object)$apiFeature)).hashCode());
        ApiUsageRecordKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)((Object)$key)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApiUsageRecordState(apiFeature=" + String.valueOf((Object)this.getApiFeature()) + ", key=" + String.valueOf((Object)this.getKey()) + ", threshold=" + this.getThreshold() + ", value=" + this.getValue() + ")";
    }
}

