/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import lombok.Generated;
import org.thingsboard.server.common.data.ApiFeature;

public enum ApiUsageRecordKey {
    TRANSPORT_MSG_COUNT(ApiFeature.TRANSPORT, "transportMsgCount", "transportMsgLimit", "message"),
    TRANSPORT_DP_COUNT(ApiFeature.TRANSPORT, "transportDataPointsCount", "transportDataPointsLimit", "data point"),
    STORAGE_DP_COUNT(ApiFeature.DB, "storageDataPointsCount", "storageDataPointsLimit", "data point"),
    RE_EXEC_COUNT(ApiFeature.RE, "ruleEngineExecutionCount", "ruleEngineExecutionLimit", "Rule Engine execution"),
    JS_EXEC_COUNT(ApiFeature.JS, "jsExecutionCount", "jsExecutionLimit", "JavaScript execution"),
    TBEL_EXEC_COUNT(ApiFeature.TBEL, "tbelExecutionCount", "tbelExecutionLimit", "Tbel execution"),
    EMAIL_EXEC_COUNT(ApiFeature.EMAIL, "emailCount", "emailLimit", "email message"),
    SMS_EXEC_COUNT(ApiFeature.SMS, "smsCount", "smsLimit", "SMS message"),
    CREATED_ALARMS_COUNT(ApiFeature.ALARM, "createdAlarmsCount", "createdAlarmsLimit", "alarm"),
    ACTIVE_DEVICES("activeDevicesCount"),
    INACTIVE_DEVICES("inactiveDevicesCount"),
    GENERATED_REPORTS_COUNT(ApiFeature.REPORT, "generatedReportsCount", "generatedReportsLimit", "report");

    private static final ApiUsageRecordKey[] JS_RECORD_KEYS;
    private static final ApiUsageRecordKey[] TBEL_RECORD_KEYS;
    private static final ApiUsageRecordKey[] RE_RECORD_KEYS;
    private static final ApiUsageRecordKey[] DB_RECORD_KEYS;
    private static final ApiUsageRecordKey[] TRANSPORT_RECORD_KEYS;
    private static final ApiUsageRecordKey[] EMAIL_RECORD_KEYS;
    private static final ApiUsageRecordKey[] SMS_RECORD_KEYS;
    private static final ApiUsageRecordKey[] ALARM_RECORD_KEYS;
    private static final ApiUsageRecordKey[] REPORT_RECORD_KEYS;
    private final ApiFeature apiFeature;
    private final String apiCountKey;
    private final String apiLimitKey;
    private final String unitLabel;
    private final boolean counter;

    private ApiUsageRecordKey(ApiFeature apiFeature, String apiCountKey, String apiLimitKey, String unitLabel) {
        this(apiFeature, apiCountKey, apiLimitKey, unitLabel, true);
    }

    private ApiUsageRecordKey(String apiCountKey) {
        this(null, apiCountKey, null, null, false);
    }

    private ApiUsageRecordKey(ApiFeature apiFeature, String apiCountKey, String apiLimitKey, String unitLabel, boolean counter) {
        this.apiFeature = apiFeature;
        this.apiCountKey = apiCountKey;
        this.apiLimitKey = apiLimitKey;
        this.unitLabel = unitLabel;
        this.counter = counter;
    }

    public static ApiUsageRecordKey[] getKeys(ApiFeature feature) {
        switch (feature) {
            case TRANSPORT: {
                return TRANSPORT_RECORD_KEYS;
            }
            case DB: {
                return DB_RECORD_KEYS;
            }
            case RE: {
                return RE_RECORD_KEYS;
            }
            case JS: {
                return JS_RECORD_KEYS;
            }
            case TBEL: {
                return TBEL_RECORD_KEYS;
            }
            case EMAIL: {
                return EMAIL_RECORD_KEYS;
            }
            case SMS: {
                return SMS_RECORD_KEYS;
            }
            case ALARM: {
                return ALARM_RECORD_KEYS;
            }
            case REPORT: {
                return REPORT_RECORD_KEYS;
            }
        }
        return new ApiUsageRecordKey[0];
    }

    @Generated
    public ApiFeature getApiFeature() {
        return this.apiFeature;
    }

    @Generated
    public String getApiCountKey() {
        return this.apiCountKey;
    }

    @Generated
    public String getApiLimitKey() {
        return this.apiLimitKey;
    }

    @Generated
    public String getUnitLabel() {
        return this.unitLabel;
    }

    @Generated
    public boolean isCounter() {
        return this.counter;
    }

    static {
        JS_RECORD_KEYS = new ApiUsageRecordKey[]{JS_EXEC_COUNT};
        TBEL_RECORD_KEYS = new ApiUsageRecordKey[]{TBEL_EXEC_COUNT};
        RE_RECORD_KEYS = new ApiUsageRecordKey[]{RE_EXEC_COUNT};
        DB_RECORD_KEYS = new ApiUsageRecordKey[]{STORAGE_DP_COUNT};
        TRANSPORT_RECORD_KEYS = new ApiUsageRecordKey[]{TRANSPORT_MSG_COUNT, TRANSPORT_DP_COUNT};
        EMAIL_RECORD_KEYS = new ApiUsageRecordKey[]{EMAIL_EXEC_COUNT};
        SMS_RECORD_KEYS = new ApiUsageRecordKey[]{SMS_EXEC_COUNT};
        ALARM_RECORD_KEYS = new ApiUsageRecordKey[]{CREATED_ALARMS_COUNT};
        REPORT_RECORD_KEYS = new ApiUsageRecordKey[]{GENERATED_REPORTS_COUNT};
    }
}

