/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.widget;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasImage;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.ResourceExportData;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;
import org.thingsboard.server.common.data.widget.BaseWidgetType;
import org.thingsboard.server.common.data.widget.WidgetType;

@JsonPropertyOrder(value={"fqn", "name", "deprecated", "image", "description", "descriptor", "externalId", "resources"})
public class WidgetTypeDetails
extends WidgetType
implements HasName,
HasTenantId,
HasImage,
ExportableEntity<WidgetTypeId> {
    @Schema(description="Relative or external image URL. Replaced with image data URL (Base64) in case of relative URL and 'inlineImages' option enabled.")
    private String image;
    @NoXss
    @Length(fieldName="description", max=1024)
    @Schema(description="Description of the widget")
    private String description;
    @NoXss
    @Schema(description="Tags of the widget type")
    private String[] tags;
    private WidgetTypeId externalId;
    private List<ResourceExportData> resources;

    public WidgetTypeDetails() {
    }

    public WidgetTypeDetails(WidgetTypeId id) {
        super(id);
    }

    public WidgetTypeDetails(BaseWidgetType baseWidgetType) {
        super(baseWidgetType);
    }

    public WidgetTypeDetails(WidgetTypeDetails widgetTypeDetails) {
        super(widgetTypeDetails);
        this.image = widgetTypeDetails.getImage();
        this.description = widgetTypeDetails.getDescription();
        this.tags = widgetTypeDetails.getTags();
        this.externalId = widgetTypeDetails.getExternalId();
        this.resources = widgetTypeDetails.getResources() != null ? new ArrayList<ResourceExportData>(widgetTypeDetails.getResources()) : null;
    }

    @Override
    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String[] getTags() {
        return this.tags;
    }

    @Override
    @Generated
    public WidgetTypeId getExternalId() {
        return this.externalId;
    }

    @Generated
    public List<ResourceExportData> getResources() {
        return this.resources;
    }

    @Override
    @Generated
    public void setImage(String image) {
        this.image = image;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setTags(String[] tags) {
        this.tags = tags;
    }

    @Override
    @Generated
    public void setExternalId(WidgetTypeId externalId) {
        this.externalId = externalId;
    }

    @Generated
    public void setResources(List<ResourceExportData> resources) {
        this.resources = resources;
    }

    @Override
    @Generated
    public String toString() {
        return "WidgetTypeDetails(image=" + this.getImage() + ", description=" + this.getDescription() + ", tags=" + Arrays.deepToString(this.getTags()) + ", externalId=" + String.valueOf(this.getExternalId()) + ", resources=" + String.valueOf(this.getResources()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WidgetTypeDetails)) {
            return false;
        }
        WidgetTypeDetails other = (WidgetTypeDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTags(), other.getTags())) {
            return false;
        }
        WidgetTypeId this$externalId = this.getExternalId();
        WidgetTypeId other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId)) {
            return false;
        }
        List<ResourceExportData> this$resources = this.getResources();
        List<ResourceExportData> other$resources = other.getResources();
        return !(this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WidgetTypeDetails;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTags());
        WidgetTypeId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        List<ResourceExportData> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        return result;
    }
}

