/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.leshan.core.LwM2m;
import org.eclipse.leshan.core.model.DDFFileValidator;
import org.eclipse.leshan.core.model.InvalidDDFFileException;
import org.eclipse.leshan.core.util.Validate;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class TbDefaultDDFFileValidator
implements DDFFileValidator {
    private static String LWM2M_V1_0_SCHEMA_PATH = "/schemas/LWM2M.xsd";
    private static String LWM2M_V1_1_SCHEMA_PATH = "/schemas/LWM2M-v1_1.xsd";
    private final String schema;

    public TbDefaultDDFFileValidator() {
        this(LwM2m.LwM2mVersion.V1_1);
    }

    public TbDefaultDDFFileValidator(LwM2m.LwM2mVersion version) {
        Validate.notNull((Object)version, (String)"version must not be null");
        if (LwM2m.LwM2mVersion.V1_0.equals((Object)version)) {
            this.schema = LWM2M_V1_0_SCHEMA_PATH;
        } else if (LwM2m.LwM2mVersion.V1_1.equals((Object)version)) {
            this.schema = LWM2M_V1_1_SCHEMA_PATH;
        } else {
            throw new IllegalStateException(String.format("Unsupported version %s", version));
        }
    }

    public void validate(Node xmlToValidate) throws InvalidDDFFileException {
        try {
            this.validate(new DOMSource(xmlToValidate));
        }
        catch (IOException | SAXException e) {
            throw new InvalidDDFFileException((Throwable)e);
        }
    }

    public void validate(Source xmlToValidate) throws SAXException, IOException {
        Validator validator = this.getEmbeddedLwM2mSchema().newValidator();
        validator.validate(xmlToValidate);
    }

    protected Schema getEmbeddedLwM2mSchema() throws SAXException {
        InputStream inputStream = DDFFileValidator.class.getResourceAsStream(this.schema);
        StreamSource source = new StreamSource(inputStream);
        SchemaFactory schemaFactory = this.createSchemaFactory();
        return schemaFactory.newSchema(source);
    }

    protected SchemaFactory createSchemaFactory() {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new IllegalStateException("Unable to create SchemaFactory", e);
        }
        return factory;
    }
}

