/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.settings;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import lombok.Generated;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.settings.UserSettingsType;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class UserSettings
implements Serializable {
    private static final long serialVersionUID = 2628320657987010348L;
    @Schema(description="JSON object with User id.", accessMode=Schema.AccessMode.READ_ONLY)
    private UserId userId;
    @Schema(description="Type of the settings.")
    @NoXss
    @Length(fieldName="type", max=50)
    private UserSettingsType type;
    @Schema(description="JSON object with user settings.", implementation=JsonNode.class)
    @NoXss
    @Length(fieldName="settings", max=100000)
    private JsonNode settings;

    @Generated
    public UserSettings() {
    }

    @Generated
    public UserId getUserId() {
        return this.userId;
    }

    @Generated
    public UserSettingsType getType() {
        return this.type;
    }

    @Generated
    public JsonNode getSettings() {
        return this.settings;
    }

    @Generated
    public void setUserId(UserId userId) {
        this.userId = userId;
    }

    @Generated
    public void setType(UserSettingsType type) {
        this.type = type;
    }

    @Generated
    public void setSettings(JsonNode settings) {
        this.settings = settings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserSettings)) {
            return false;
        }
        UserSettings other = (UserSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UserId this$userId = this.getUserId();
        UserId other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        UserSettingsType this$type = this.getType();
        UserSettingsType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        JsonNode this$settings = this.getSettings();
        JsonNode other$settings = other.getSettings();
        return !(this$settings == null ? other$settings != null : !this$settings.equals(other$settings));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserId $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        UserSettingsType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        JsonNode $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserSettings(userId=" + String.valueOf(this.getUserId()) + ", type=" + String.valueOf((Object)this.getType()) + ", settings=" + String.valueOf(this.getSettings()) + ")";
    }
}

