/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.security.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import lombok.Generated;

@Schema
public class UserPasswordPolicy
implements Serializable {
    @Schema(description="Minimum number of symbols in the password.")
    private Integer minimumLength;
    @Schema(description="Maximum number of symbols in the password.")
    private Integer maximumLength;
    @Schema(description="Minimum number of uppercase letters in the password.")
    private Integer minimumUppercaseLetters;
    @Schema(description="Minimum number of lowercase letters in the password.")
    private Integer minimumLowercaseLetters;
    @Schema(description="Minimum number of digits in the password.")
    private Integer minimumDigits;
    @Schema(description="Minimum number of special in the password.")
    private Integer minimumSpecialCharacters;
    @Schema(description="Allow whitespaces")
    private Boolean allowWhitespaces = true;
    @Schema(description="Force user to update password if existing one does not pass validation")
    private Boolean forceUserToResetPasswordIfNotValid = false;
    @Schema(description="Password expiration period (days). Force expiration of the password.")
    private Integer passwordExpirationPeriodDays;
    @Schema(description="Password reuse frequency (days). Disallow to use the same password for the defined number of days")
    private Integer passwordReuseFrequencyDays;

    @Generated
    public UserPasswordPolicy() {
    }

    @Generated
    public Integer getMinimumLength() {
        return this.minimumLength;
    }

    @Generated
    public Integer getMaximumLength() {
        return this.maximumLength;
    }

    @Generated
    public Integer getMinimumUppercaseLetters() {
        return this.minimumUppercaseLetters;
    }

    @Generated
    public Integer getMinimumLowercaseLetters() {
        return this.minimumLowercaseLetters;
    }

    @Generated
    public Integer getMinimumDigits() {
        return this.minimumDigits;
    }

    @Generated
    public Integer getMinimumSpecialCharacters() {
        return this.minimumSpecialCharacters;
    }

    @Generated
    public Boolean getAllowWhitespaces() {
        return this.allowWhitespaces;
    }

    @Generated
    public Boolean getForceUserToResetPasswordIfNotValid() {
        return this.forceUserToResetPasswordIfNotValid;
    }

    @Generated
    public Integer getPasswordExpirationPeriodDays() {
        return this.passwordExpirationPeriodDays;
    }

    @Generated
    public Integer getPasswordReuseFrequencyDays() {
        return this.passwordReuseFrequencyDays;
    }

    @Generated
    public void setMinimumLength(Integer minimumLength) {
        this.minimumLength = minimumLength;
    }

    @Generated
    public void setMaximumLength(Integer maximumLength) {
        this.maximumLength = maximumLength;
    }

    @Generated
    public void setMinimumUppercaseLetters(Integer minimumUppercaseLetters) {
        this.minimumUppercaseLetters = minimumUppercaseLetters;
    }

    @Generated
    public void setMinimumLowercaseLetters(Integer minimumLowercaseLetters) {
        this.minimumLowercaseLetters = minimumLowercaseLetters;
    }

    @Generated
    public void setMinimumDigits(Integer minimumDigits) {
        this.minimumDigits = minimumDigits;
    }

    @Generated
    public void setMinimumSpecialCharacters(Integer minimumSpecialCharacters) {
        this.minimumSpecialCharacters = minimumSpecialCharacters;
    }

    @Generated
    public void setAllowWhitespaces(Boolean allowWhitespaces) {
        this.allowWhitespaces = allowWhitespaces;
    }

    @Generated
    public void setForceUserToResetPasswordIfNotValid(Boolean forceUserToResetPasswordIfNotValid) {
        this.forceUserToResetPasswordIfNotValid = forceUserToResetPasswordIfNotValid;
    }

    @Generated
    public void setPasswordExpirationPeriodDays(Integer passwordExpirationPeriodDays) {
        this.passwordExpirationPeriodDays = passwordExpirationPeriodDays;
    }

    @Generated
    public void setPasswordReuseFrequencyDays(Integer passwordReuseFrequencyDays) {
        this.passwordReuseFrequencyDays = passwordReuseFrequencyDays;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserPasswordPolicy)) {
            return false;
        }
        UserPasswordPolicy other = (UserPasswordPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$minimumLength = this.getMinimumLength();
        Integer other$minimumLength = other.getMinimumLength();
        if (this$minimumLength == null ? other$minimumLength != null : !((Object)this$minimumLength).equals(other$minimumLength)) {
            return false;
        }
        Integer this$maximumLength = this.getMaximumLength();
        Integer other$maximumLength = other.getMaximumLength();
        if (this$maximumLength == null ? other$maximumLength != null : !((Object)this$maximumLength).equals(other$maximumLength)) {
            return false;
        }
        Integer this$minimumUppercaseLetters = this.getMinimumUppercaseLetters();
        Integer other$minimumUppercaseLetters = other.getMinimumUppercaseLetters();
        if (this$minimumUppercaseLetters == null ? other$minimumUppercaseLetters != null : !((Object)this$minimumUppercaseLetters).equals(other$minimumUppercaseLetters)) {
            return false;
        }
        Integer this$minimumLowercaseLetters = this.getMinimumLowercaseLetters();
        Integer other$minimumLowercaseLetters = other.getMinimumLowercaseLetters();
        if (this$minimumLowercaseLetters == null ? other$minimumLowercaseLetters != null : !((Object)this$minimumLowercaseLetters).equals(other$minimumLowercaseLetters)) {
            return false;
        }
        Integer this$minimumDigits = this.getMinimumDigits();
        Integer other$minimumDigits = other.getMinimumDigits();
        if (this$minimumDigits == null ? other$minimumDigits != null : !((Object)this$minimumDigits).equals(other$minimumDigits)) {
            return false;
        }
        Integer this$minimumSpecialCharacters = this.getMinimumSpecialCharacters();
        Integer other$minimumSpecialCharacters = other.getMinimumSpecialCharacters();
        if (this$minimumSpecialCharacters == null ? other$minimumSpecialCharacters != null : !((Object)this$minimumSpecialCharacters).equals(other$minimumSpecialCharacters)) {
            return false;
        }
        Boolean this$allowWhitespaces = this.getAllowWhitespaces();
        Boolean other$allowWhitespaces = other.getAllowWhitespaces();
        if (this$allowWhitespaces == null ? other$allowWhitespaces != null : !((Object)this$allowWhitespaces).equals(other$allowWhitespaces)) {
            return false;
        }
        Boolean this$forceUserToResetPasswordIfNotValid = this.getForceUserToResetPasswordIfNotValid();
        Boolean other$forceUserToResetPasswordIfNotValid = other.getForceUserToResetPasswordIfNotValid();
        if (this$forceUserToResetPasswordIfNotValid == null ? other$forceUserToResetPasswordIfNotValid != null : !((Object)this$forceUserToResetPasswordIfNotValid).equals(other$forceUserToResetPasswordIfNotValid)) {
            return false;
        }
        Integer this$passwordExpirationPeriodDays = this.getPasswordExpirationPeriodDays();
        Integer other$passwordExpirationPeriodDays = other.getPasswordExpirationPeriodDays();
        if (this$passwordExpirationPeriodDays == null ? other$passwordExpirationPeriodDays != null : !((Object)this$passwordExpirationPeriodDays).equals(other$passwordExpirationPeriodDays)) {
            return false;
        }
        Integer this$passwordReuseFrequencyDays = this.getPasswordReuseFrequencyDays();
        Integer other$passwordReuseFrequencyDays = other.getPasswordReuseFrequencyDays();
        return !(this$passwordReuseFrequencyDays == null ? other$passwordReuseFrequencyDays != null : !((Object)this$passwordReuseFrequencyDays).equals(other$passwordReuseFrequencyDays));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserPasswordPolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minimumLength = this.getMinimumLength();
        result = result * 59 + ($minimumLength == null ? 43 : ((Object)$minimumLength).hashCode());
        Integer $maximumLength = this.getMaximumLength();
        result = result * 59 + ($maximumLength == null ? 43 : ((Object)$maximumLength).hashCode());
        Integer $minimumUppercaseLetters = this.getMinimumUppercaseLetters();
        result = result * 59 + ($minimumUppercaseLetters == null ? 43 : ((Object)$minimumUppercaseLetters).hashCode());
        Integer $minimumLowercaseLetters = this.getMinimumLowercaseLetters();
        result = result * 59 + ($minimumLowercaseLetters == null ? 43 : ((Object)$minimumLowercaseLetters).hashCode());
        Integer $minimumDigits = this.getMinimumDigits();
        result = result * 59 + ($minimumDigits == null ? 43 : ((Object)$minimumDigits).hashCode());
        Integer $minimumSpecialCharacters = this.getMinimumSpecialCharacters();
        result = result * 59 + ($minimumSpecialCharacters == null ? 43 : ((Object)$minimumSpecialCharacters).hashCode());
        Boolean $allowWhitespaces = this.getAllowWhitespaces();
        result = result * 59 + ($allowWhitespaces == null ? 43 : ((Object)$allowWhitespaces).hashCode());
        Boolean $forceUserToResetPasswordIfNotValid = this.getForceUserToResetPasswordIfNotValid();
        result = result * 59 + ($forceUserToResetPasswordIfNotValid == null ? 43 : ((Object)$forceUserToResetPasswordIfNotValid).hashCode());
        Integer $passwordExpirationPeriodDays = this.getPasswordExpirationPeriodDays();
        result = result * 59 + ($passwordExpirationPeriodDays == null ? 43 : ((Object)$passwordExpirationPeriodDays).hashCode());
        Integer $passwordReuseFrequencyDays = this.getPasswordReuseFrequencyDays();
        result = result * 59 + ($passwordReuseFrequencyDays == null ? 43 : ((Object)$passwordReuseFrequencyDays).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserPasswordPolicy(minimumLength=" + this.getMinimumLength() + ", maximumLength=" + this.getMaximumLength() + ", minimumUppercaseLetters=" + this.getMinimumUppercaseLetters() + ", minimumLowercaseLetters=" + this.getMinimumLowercaseLetters() + ", minimumDigits=" + this.getMinimumDigits() + ", minimumSpecialCharacters=" + this.getMinimumSpecialCharacters() + ", allowWhitespaces=" + this.getAllowWhitespaces() + ", forceUserToResetPasswordIfNotValid=" + this.getForceUserToResetPasswordIfNotValid() + ", passwordExpirationPeriodDays=" + this.getPasswordExpirationPeriodDays() + ", passwordReuseFrequencyDays=" + this.getPasswordReuseFrequencyDays() + ")";
    }
}

