/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.id.UserCredentialsId;
import org.thingsboard.server.common.data.id.UserId;

public class UserCredentials
extends BaseDataWithAdditionalInfo<UserCredentialsId> {
    private static final long serialVersionUID = -2108436378880529163L;
    private UserId userId;
    private boolean enabled;
    private String password;
    private String activateToken;
    private Long activateTokenExpTime;
    private String resetToken;
    private Long resetTokenExpTime;
    private Long lastLoginTs;
    private Integer failedLoginAttempts;

    public UserCredentials() {
    }

    public UserCredentials(UserCredentialsId id) {
        super(id);
    }

    @JsonIgnore
    public boolean isActivationTokenExpired() {
        return this.getActivationTokenTtl() == 0L;
    }

    @JsonIgnore
    public long getActivationTokenTtl() {
        return this.activateTokenExpTime != null ? Math.max(this.activateTokenExpTime - System.currentTimeMillis(), 0L) : 0L;
    }

    @JsonIgnore
    public boolean isResetTokenExpired() {
        return this.getResetTokenTtl() == 0L;
    }

    @JsonIgnore
    public long getResetTokenTtl() {
        return this.resetTokenExpTime != null ? Math.max(this.resetTokenExpTime - System.currentTimeMillis(), 0L) : 0L;
    }

    @Generated
    public UserId getUserId() {
        return this.userId;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getActivateToken() {
        return this.activateToken;
    }

    @Generated
    public Long getActivateTokenExpTime() {
        return this.activateTokenExpTime;
    }

    @Generated
    public String getResetToken() {
        return this.resetToken;
    }

    @Generated
    public Long getResetTokenExpTime() {
        return this.resetTokenExpTime;
    }

    @Generated
    public Long getLastLoginTs() {
        return this.lastLoginTs;
    }

    @Generated
    public Integer getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    @Generated
    public void setUserId(UserId userId) {
        this.userId = userId;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setActivateToken(String activateToken) {
        this.activateToken = activateToken;
    }

    @Generated
    public void setActivateTokenExpTime(Long activateTokenExpTime) {
        this.activateTokenExpTime = activateTokenExpTime;
    }

    @Generated
    public void setResetToken(String resetToken) {
        this.resetToken = resetToken;
    }

    @Generated
    public void setResetTokenExpTime(Long resetTokenExpTime) {
        this.resetTokenExpTime = resetTokenExpTime;
    }

    @Generated
    public void setLastLoginTs(Long lastLoginTs) {
        this.lastLoginTs = lastLoginTs;
    }

    @Generated
    public void setFailedLoginAttempts(Integer failedLoginAttempts) {
        this.failedLoginAttempts = failedLoginAttempts;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserCredentials)) {
            return false;
        }
        UserCredentials other = (UserCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Long this$activateTokenExpTime = this.getActivateTokenExpTime();
        Long other$activateTokenExpTime = other.getActivateTokenExpTime();
        if (this$activateTokenExpTime == null ? other$activateTokenExpTime != null : !((Object)this$activateTokenExpTime).equals(other$activateTokenExpTime)) {
            return false;
        }
        Long this$resetTokenExpTime = this.getResetTokenExpTime();
        Long other$resetTokenExpTime = other.getResetTokenExpTime();
        if (this$resetTokenExpTime == null ? other$resetTokenExpTime != null : !((Object)this$resetTokenExpTime).equals(other$resetTokenExpTime)) {
            return false;
        }
        Long this$lastLoginTs = this.getLastLoginTs();
        Long other$lastLoginTs = other.getLastLoginTs();
        if (this$lastLoginTs == null ? other$lastLoginTs != null : !((Object)this$lastLoginTs).equals(other$lastLoginTs)) {
            return false;
        }
        Integer this$failedLoginAttempts = this.getFailedLoginAttempts();
        Integer other$failedLoginAttempts = other.getFailedLoginAttempts();
        if (this$failedLoginAttempts == null ? other$failedLoginAttempts != null : !((Object)this$failedLoginAttempts).equals(other$failedLoginAttempts)) {
            return false;
        }
        UserId this$userId = this.getUserId();
        UserId other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$activateToken = this.getActivateToken();
        String other$activateToken = other.getActivateToken();
        if (this$activateToken == null ? other$activateToken != null : !this$activateToken.equals(other$activateToken)) {
            return false;
        }
        String this$resetToken = this.getResetToken();
        String other$resetToken = other.getResetToken();
        return !(this$resetToken == null ? other$resetToken != null : !this$resetToken.equals(other$resetToken));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserCredentials;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Long $activateTokenExpTime = this.getActivateTokenExpTime();
        result = result * 59 + ($activateTokenExpTime == null ? 43 : ((Object)$activateTokenExpTime).hashCode());
        Long $resetTokenExpTime = this.getResetTokenExpTime();
        result = result * 59 + ($resetTokenExpTime == null ? 43 : ((Object)$resetTokenExpTime).hashCode());
        Long $lastLoginTs = this.getLastLoginTs();
        result = result * 59 + ($lastLoginTs == null ? 43 : ((Object)$lastLoginTs).hashCode());
        Integer $failedLoginAttempts = this.getFailedLoginAttempts();
        result = result * 59 + ($failedLoginAttempts == null ? 43 : ((Object)$failedLoginAttempts).hashCode());
        UserId $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $activateToken = this.getActivateToken();
        result = result * 59 + ($activateToken == null ? 43 : $activateToken.hashCode());
        String $resetToken = this.getResetToken();
        result = result * 59 + ($resetToken == null ? 43 : $resetToken.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "UserCredentials(super=" + super.toString() + ", userId=" + String.valueOf(this.getUserId()) + ", enabled=" + this.isEnabled() + ", password=" + this.getPassword() + ", activateToken=" + this.getActivateToken() + ", activateTokenExpTime=" + this.getActivateTokenExpTime() + ", resetToken=" + this.getResetToken() + ", resetTokenExpTime=" + this.getResetTokenExpTime() + ", lastLoginTs=" + this.getLastLoginTs() + ", failedLoginAttempts=" + this.getFailedLoginAttempts() + ")";
    }
}

