/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.rule;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.HasDebugSettings;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.debug.DebugSettings;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
@JsonIgnoreProperties(ignoreUnknown=true)
public class RuleNode
extends BaseDataWithAdditionalInfo<RuleNodeId>
implements HasName,
HasDebugSettings {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleNode.class);
    private static final long serialVersionUID = -5656679015121235465L;
    @Schema(description="JSON object with the Rule Chain Id. ", accessMode=Schema.AccessMode.READ_ONLY)
    private RuleChainId ruleChainId;
    @Length(fieldName="type")
    @Schema(description="Full Java Class Name of the rule node implementation. ", example="com.mycompany.iot.rule.engine.ProcessingNode")
    private String type;
    @NoXss
    @Length(fieldName="name")
    @Schema(description="User defined name of the rule node. Used on UI and for logging. ", example="Process sensor reading")
    private String name;
    @Deprecated
    @Schema(description="Enable/disable debug. ", example="false", deprecated=true)
    private boolean debugMode;
    @Schema(description="Debug settings object.")
    private DebugSettings debugSettings;
    @Schema(description="Enable/disable singleton mode. ", example="false")
    private boolean singletonMode;
    @Schema(description="Queue name. ", example="Main")
    private String queueName;
    @Schema(description="Version of rule node configuration. ", example="0")
    private int configurationVersion;
    @Schema(description="JSON with the rule node configuration. Structure depends on the rule node implementation.", implementation=JsonNode.class)
    private JsonNode configuration;
    private RuleNodeId externalId;

    public RuleNode() {
    }

    public RuleNode(RuleNodeId id) {
        super(id);
    }

    public RuleNode(RuleNode ruleNode) {
        super(ruleNode);
        this.ruleChainId = ruleNode.getRuleChainId();
        this.type = ruleNode.getType();
        this.name = ruleNode.getName();
        this.debugSettings = ruleNode.getDebugSettings();
        this.singletonMode = ruleNode.isSingletonMode();
        this.setConfiguration(ruleNode.getConfiguration());
        this.externalId = ruleNode.getExternalId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Schema(description="JSON object with the Rule Node Id. Specify this field to update the Rule Node. Referencing non-existing Rule Node Id will cause error. Omit this field to create new rule node.")
    public RuleNodeId getId() {
        return (RuleNodeId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the rule node creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    @Schema(description="Additional parameters of the rule node. Contains 'layoutX' and 'layoutY' properties for visualization.", implementation=JsonNode.class)
    public JsonNode getAdditionalInfo() {
        return super.getAdditionalInfo();
    }

    @Override
    @JsonIgnore
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    @JsonSetter
    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @Generated
    public RuleChainId getRuleChainId() {
        return this.ruleChainId;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @Generated
    public DebugSettings getDebugSettings() {
        return this.debugSettings;
    }

    @Generated
    public boolean isSingletonMode() {
        return this.singletonMode;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public int getConfigurationVersion() {
        return this.configurationVersion;
    }

    @Generated
    public JsonNode getConfiguration() {
        return this.configuration;
    }

    @Generated
    public RuleNodeId getExternalId() {
        return this.externalId;
    }

    @Generated
    public void setRuleChainId(RuleChainId ruleChainId) {
        this.ruleChainId = ruleChainId;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Generated
    public void setDebugSettings(DebugSettings debugSettings) {
        this.debugSettings = debugSettings;
    }

    @Generated
    public void setSingletonMode(boolean singletonMode) {
        this.singletonMode = singletonMode;
    }

    @Generated
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Generated
    public void setConfigurationVersion(int configurationVersion) {
        this.configurationVersion = configurationVersion;
    }

    @Generated
    public void setConfiguration(JsonNode configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setExternalId(RuleNodeId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public String toString() {
        return "RuleNode(ruleChainId=" + String.valueOf(this.getRuleChainId()) + ", type=" + this.getType() + ", name=" + this.getName() + ", debugMode=" + this.isDebugMode() + ", debugSettings=" + String.valueOf(this.getDebugSettings()) + ", singletonMode=" + this.isSingletonMode() + ", queueName=" + this.getQueueName() + ", configurationVersion=" + this.getConfigurationVersion() + ", configuration=" + String.valueOf(this.getConfiguration()) + ", externalId=" + String.valueOf(this.getExternalId()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleNode)) {
            return false;
        }
        RuleNode other = (RuleNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDebugMode() != other.isDebugMode()) {
            return false;
        }
        if (this.isSingletonMode() != other.isSingletonMode()) {
            return false;
        }
        if (this.getConfigurationVersion() != other.getConfigurationVersion()) {
            return false;
        }
        RuleChainId this$ruleChainId = this.getRuleChainId();
        RuleChainId other$ruleChainId = other.getRuleChainId();
        if (this$ruleChainId == null ? other$ruleChainId != null : !((Object)this$ruleChainId).equals(other$ruleChainId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DebugSettings this$debugSettings = this.getDebugSettings();
        DebugSettings other$debugSettings = other.getDebugSettings();
        if (this$debugSettings == null ? other$debugSettings != null : !((Object)this$debugSettings).equals(other$debugSettings)) {
            return false;
        }
        String this$queueName = this.getQueueName();
        String other$queueName = other.getQueueName();
        if (this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName)) {
            return false;
        }
        JsonNode this$configuration = this.getConfiguration();
        JsonNode other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        RuleNodeId this$externalId = this.getExternalId();
        RuleNodeId other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RuleNode;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDebugMode() ? 79 : 97);
        result = result * 59 + (this.isSingletonMode() ? 79 : 97);
        result = result * 59 + this.getConfigurationVersion();
        RuleChainId $ruleChainId = this.getRuleChainId();
        result = result * 59 + ($ruleChainId == null ? 43 : ((Object)$ruleChainId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DebugSettings $debugSettings = this.getDebugSettings();
        result = result * 59 + ($debugSettings == null ? 43 : ((Object)$debugSettings).hashCode());
        String $queueName = this.getQueueName();
        result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
        JsonNode $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        RuleNodeId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        return result;
    }
}

