/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.rule;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.rule.NodeConnectionInfo;
import org.thingsboard.server.common.data.rule.RuleChainConnectionInfo;
import org.thingsboard.server.common.data.rule.RuleNode;

@Schema
public class RuleChainMetaData
implements HasVersion {
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="JSON object with Rule Chain Id.", accessMode=Schema.AccessMode.READ_ONLY)
    private RuleChainId ruleChainId;
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED, description="Version of the Rule Chain")
    private Long version;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Index of the first rule node in the 'nodes' list")
    private Integer firstNodeIndex;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="List of rule node JSON objects")
    private List<RuleNode> nodes;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="List of JSON objects that represent connections between rule nodes")
    private List<NodeConnectionInfo> connections;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="List of JSON objects that represent connections between rule nodes and other rule chains.")
    private List<RuleChainConnectionInfo> ruleChainConnections;

    public void addConnectionInfo(int fromIndex, int toIndex, String type) {
        NodeConnectionInfo connectionInfo = new NodeConnectionInfo();
        connectionInfo.setFromIndex(fromIndex);
        connectionInfo.setToIndex(toIndex);
        connectionInfo.setType(type);
        if (this.connections == null) {
            this.connections = new ArrayList<NodeConnectionInfo>();
        }
        this.connections.add(connectionInfo);
    }

    @Generated
    public RuleChainMetaData() {
    }

    @Generated
    public RuleChainId getRuleChainId() {
        return this.ruleChainId;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public Integer getFirstNodeIndex() {
        return this.firstNodeIndex;
    }

    @Generated
    public List<RuleNode> getNodes() {
        return this.nodes;
    }

    @Generated
    public List<NodeConnectionInfo> getConnections() {
        return this.connections;
    }

    @Generated
    public List<RuleChainConnectionInfo> getRuleChainConnections() {
        return this.ruleChainConnections;
    }

    @Generated
    public void setRuleChainId(RuleChainId ruleChainId) {
        this.ruleChainId = ruleChainId;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public void setFirstNodeIndex(Integer firstNodeIndex) {
        this.firstNodeIndex = firstNodeIndex;
    }

    @Generated
    public void setNodes(List<RuleNode> nodes) {
        this.nodes = nodes;
    }

    @Generated
    public void setConnections(List<NodeConnectionInfo> connections) {
        this.connections = connections;
    }

    @Generated
    public void setRuleChainConnections(List<RuleChainConnectionInfo> ruleChainConnections) {
        this.ruleChainConnections = ruleChainConnections;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleChainMetaData)) {
            return false;
        }
        RuleChainMetaData other = (RuleChainMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Integer this$firstNodeIndex = this.getFirstNodeIndex();
        Integer other$firstNodeIndex = other.getFirstNodeIndex();
        if (this$firstNodeIndex == null ? other$firstNodeIndex != null : !((Object)this$firstNodeIndex).equals(other$firstNodeIndex)) {
            return false;
        }
        RuleChainId this$ruleChainId = this.getRuleChainId();
        RuleChainId other$ruleChainId = other.getRuleChainId();
        if (this$ruleChainId == null ? other$ruleChainId != null : !((Object)this$ruleChainId).equals(other$ruleChainId)) {
            return false;
        }
        List<RuleNode> this$nodes = this.getNodes();
        List<RuleNode> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        List<NodeConnectionInfo> this$connections = this.getConnections();
        List<NodeConnectionInfo> other$connections = other.getConnections();
        if (this$connections == null ? other$connections != null : !((Object)this$connections).equals(other$connections)) {
            return false;
        }
        List<RuleChainConnectionInfo> this$ruleChainConnections = this.getRuleChainConnections();
        List<RuleChainConnectionInfo> other$ruleChainConnections = other.getRuleChainConnections();
        return !(this$ruleChainConnections == null ? other$ruleChainConnections != null : !((Object)this$ruleChainConnections).equals(other$ruleChainConnections));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RuleChainMetaData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Integer $firstNodeIndex = this.getFirstNodeIndex();
        result = result * 59 + ($firstNodeIndex == null ? 43 : ((Object)$firstNodeIndex).hashCode());
        RuleChainId $ruleChainId = this.getRuleChainId();
        result = result * 59 + ($ruleChainId == null ? 43 : ((Object)$ruleChainId).hashCode());
        List<RuleNode> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        List<NodeConnectionInfo> $connections = this.getConnections();
        result = result * 59 + ($connections == null ? 43 : ((Object)$connections).hashCode());
        List<RuleChainConnectionInfo> $ruleChainConnections = this.getRuleChainConnections();
        result = result * 59 + ($ruleChainConnections == null ? 43 : ((Object)$ruleChainConnections).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RuleChainMetaData(ruleChainId=" + String.valueOf(this.getRuleChainId()) + ", version=" + this.getVersion() + ", firstNodeIndex=" + this.getFirstNodeIndex() + ", nodes=" + String.valueOf(this.getNodes()) + ", connections=" + String.valueOf(this.getConnections()) + ", ruleChainConnections=" + String.valueOf(this.getRuleChainConnections()) + ")";
    }
}

