/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.rule;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.BaseDataWithAdditionalInfo;
import org.thingsboard.server.common.data.ExportableEntity;
import org.thingsboard.server.common.data.HasDefaultOption;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.HasVersion;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

@Schema
public class RuleChain
extends BaseDataWithAdditionalInfo<RuleChainId>
implements HasName,
HasTenantId,
ExportableEntity<RuleChainId>,
HasDefaultOption,
HasVersion {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleChain.class);
    private static final long serialVersionUID = -5656679015121935465L;
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="JSON object with Tenant Id.", accessMode=Schema.AccessMode.READ_ONLY)
    private TenantId tenantId;
    @NoXss
    @Length(fieldName="name")
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="Rule Chain name", example="Humidity data processing")
    private String name;
    @Schema(description="Rule Chain type. 'EDGE' rule chains are processing messages on the edge devices only.", example="A4B72CCDFF33")
    private RuleChainType type;
    @Schema(description="JSON object with Rule Chain Id. Pointer to the first rule node that should receive all messages pushed to this rule chain.")
    private RuleNodeId firstRuleNodeId;
    @Schema(description="Indicates root rule chain. The root rule chain process messages from all devices and entities by default. User may configure default rule chain per device profile.")
    private boolean root;
    @Schema(description="Reserved for future usage.")
    private boolean debugMode;
    @Schema(description="Reserved for future usage. The actual list of rule nodes and their relations is stored in the database separately.")
    private transient JsonNode configuration;
    private RuleChainId externalId;
    private Long version;
    @JsonIgnore
    private byte[] configurationBytes;

    public RuleChain() {
    }

    public RuleChain(RuleChainId id) {
        super(id);
    }

    public RuleChain(RuleChain ruleChain) {
        super(ruleChain);
        this.tenantId = ruleChain.getTenantId();
        this.name = ruleChain.getName();
        this.type = ruleChain.getType();
        this.firstRuleNodeId = ruleChain.getFirstRuleNodeId();
        this.root = ruleChain.isRoot();
        this.setConfiguration(ruleChain.getConfiguration());
        this.setExternalId(ruleChain.getExternalId());
        this.version = ruleChain.getVersion();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Schema(description="JSON object with the Rule Chain Id. Specify this field to update the Rule Chain. Referencing non-existing Rule Chain Id will cause error. Omit this field to create new rule chain.")
    public RuleChainId getId() {
        return (RuleChainId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the rule chain creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    public JsonNode getConfiguration() {
        return BaseDataWithAdditionalInfo.getJson(() -> this.configuration, () -> this.configurationBytes);
    }

    public void setConfiguration(JsonNode data) {
        RuleChain.setJson(data, json -> {
            this.configuration = json;
        }, bytes -> {
            this.configurationBytes = bytes;
        });
    }

    @Override
    @JsonIgnore
    public boolean isDefault() {
        return this.root && this.type == RuleChainType.CORE;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public RuleChainType getType() {
        return this.type;
    }

    @Generated
    public RuleNodeId getFirstRuleNodeId() {
        return this.firstRuleNodeId;
    }

    @Generated
    public boolean isRoot() {
        return this.root;
    }

    @Generated
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    @Generated
    public RuleChainId getExternalId() {
        return this.externalId;
    }

    @Override
    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public byte[] getConfigurationBytes() {
        return this.configurationBytes;
    }

    @Override
    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(RuleChainType type) {
        this.type = type;
    }

    @Generated
    public void setFirstRuleNodeId(RuleNodeId firstRuleNodeId) {
        this.firstRuleNodeId = firstRuleNodeId;
    }

    @Generated
    public void setRoot(boolean root) {
        this.root = root;
    }

    @Generated
    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    @Generated
    public void setExternalId(RuleChainId externalId) {
        this.externalId = externalId;
    }

    @Override
    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @JsonIgnore
    @Generated
    public void setConfigurationBytes(byte[] configurationBytes) {
        this.configurationBytes = configurationBytes;
    }

    @Override
    @Generated
    public String toString() {
        return "RuleChain(tenantId=" + String.valueOf(this.getTenantId()) + ", name=" + this.getName() + ", type=" + String.valueOf((Object)this.getType()) + ", firstRuleNodeId=" + String.valueOf(this.getFirstRuleNodeId()) + ", root=" + this.isRoot() + ", debugMode=" + this.isDebugMode() + ", configuration=" + String.valueOf(this.getConfiguration()) + ", externalId=" + String.valueOf(this.getExternalId()) + ", version=" + this.getVersion() + ", configurationBytes=" + Arrays.toString(this.getConfigurationBytes()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleChain)) {
            return false;
        }
        RuleChain other = (RuleChain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isRoot() != other.isRoot()) {
            return false;
        }
        if (this.isDebugMode() != other.isDebugMode()) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        RuleChainType this$type = this.getType();
        RuleChainType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        RuleNodeId this$firstRuleNodeId = this.getFirstRuleNodeId();
        RuleNodeId other$firstRuleNodeId = other.getFirstRuleNodeId();
        if (this$firstRuleNodeId == null ? other$firstRuleNodeId != null : !((Object)this$firstRuleNodeId).equals(other$firstRuleNodeId)) {
            return false;
        }
        RuleChainId this$externalId = this.getExternalId();
        RuleChainId other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !((Object)this$externalId).equals(other$externalId)) {
            return false;
        }
        return Arrays.equals(this.getConfigurationBytes(), other.getConfigurationBytes());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RuleChain;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isRoot() ? 79 : 97);
        result = result * 59 + (this.isDebugMode() ? 79 : 97);
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        RuleChainType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        RuleNodeId $firstRuleNodeId = this.getFirstRuleNodeId();
        result = result * 59 + ($firstRuleNodeId == null ? 43 : ((Object)$firstRuleNodeId).hashCode());
        RuleChainId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : ((Object)$externalId).hashCode());
        result = result * 59 + Arrays.hashCode(this.getConfigurationBytes());
        return result;
    }
}

