/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.relation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;

@Schema
public class RelationsSearchParameters {
    @Schema(description="Root entity id to start search from.", example="784f394c-42b6-435a-983c-b7beff2784f9")
    private UUID rootId;
    @Schema(description="Type of the root entity.")
    private EntityType rootType;
    @Schema(description="Type of the root entity.")
    private EntitySearchDirection direction;
    @Schema(description="Type of the relation.")
    private RelationTypeGroup relationTypeGroup;
    @Schema(description="Maximum level of the search depth.")
    private int maxLevel = 1;
    @Schema(description="Fetch entities that match the last level of search. Useful to find Devices that are strictly 'maxLevel' relations away from the root entity.")
    private boolean fetchLastLevelOnly;

    public RelationsSearchParameters(EntityId entityId, EntitySearchDirection direction, int maxLevel, boolean fetchLastLevelOnly) {
        this(entityId, direction, maxLevel, RelationTypeGroup.COMMON, fetchLastLevelOnly);
    }

    public RelationsSearchParameters(EntityId entityId, EntitySearchDirection direction, int maxLevel, RelationTypeGroup relationTypeGroup, boolean fetchLastLevelOnly) {
        this.rootId = entityId.getId();
        this.rootType = entityId.getEntityType();
        this.direction = direction;
        this.maxLevel = maxLevel;
        this.relationTypeGroup = relationTypeGroup;
        this.fetchLastLevelOnly = fetchLastLevelOnly;
    }

    @JsonIgnore
    public EntityId getEntityId() {
        return EntityIdFactory.getByTypeAndUuid(this.rootType, this.rootId);
    }

    @Generated
    public UUID getRootId() {
        return this.rootId;
    }

    @Generated
    public EntityType getRootType() {
        return this.rootType;
    }

    @Generated
    public EntitySearchDirection getDirection() {
        return this.direction;
    }

    @Generated
    public RelationTypeGroup getRelationTypeGroup() {
        return this.relationTypeGroup;
    }

    @Generated
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Generated
    public boolean isFetchLastLevelOnly() {
        return this.fetchLastLevelOnly;
    }

    @Generated
    public void setRootId(UUID rootId) {
        this.rootId = rootId;
    }

    @Generated
    public void setRootType(EntityType rootType) {
        this.rootType = rootType;
    }

    @Generated
    public void setDirection(EntitySearchDirection direction) {
        this.direction = direction;
    }

    @Generated
    public void setRelationTypeGroup(RelationTypeGroup relationTypeGroup) {
        this.relationTypeGroup = relationTypeGroup;
    }

    @Generated
    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    @Generated
    public void setFetchLastLevelOnly(boolean fetchLastLevelOnly) {
        this.fetchLastLevelOnly = fetchLastLevelOnly;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationsSearchParameters)) {
            return false;
        }
        RelationsSearchParameters other = (RelationsSearchParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxLevel() != other.getMaxLevel()) {
            return false;
        }
        if (this.isFetchLastLevelOnly() != other.isFetchLastLevelOnly()) {
            return false;
        }
        UUID this$rootId = this.getRootId();
        UUID other$rootId = other.getRootId();
        if (this$rootId == null ? other$rootId != null : !((Object)this$rootId).equals(other$rootId)) {
            return false;
        }
        EntityType this$rootType = this.getRootType();
        EntityType other$rootType = other.getRootType();
        if (this$rootType == null ? other$rootType != null : !((Object)((Object)this$rootType)).equals((Object)other$rootType)) {
            return false;
        }
        EntitySearchDirection this$direction = this.getDirection();
        EntitySearchDirection other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
            return false;
        }
        RelationTypeGroup this$relationTypeGroup = this.getRelationTypeGroup();
        RelationTypeGroup other$relationTypeGroup = other.getRelationTypeGroup();
        return !(this$relationTypeGroup == null ? other$relationTypeGroup != null : !((Object)((Object)this$relationTypeGroup)).equals((Object)other$relationTypeGroup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RelationsSearchParameters;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxLevel();
        result = result * 59 + (this.isFetchLastLevelOnly() ? 79 : 97);
        UUID $rootId = this.getRootId();
        result = result * 59 + ($rootId == null ? 43 : ((Object)$rootId).hashCode());
        EntityType $rootType = this.getRootType();
        result = result * 59 + ($rootType == null ? 43 : ((Object)((Object)$rootType)).hashCode());
        EntitySearchDirection $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        RelationTypeGroup $relationTypeGroup = this.getRelationTypeGroup();
        result = result * 59 + ($relationTypeGroup == null ? 43 : ((Object)((Object)$relationTypeGroup)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RelationsSearchParameters(rootId=" + String.valueOf(this.getRootId()) + ", rootType=" + String.valueOf((Object)this.getRootType()) + ", direction=" + String.valueOf((Object)this.getDirection()) + ", relationTypeGroup=" + String.valueOf((Object)this.getRelationTypeGroup()) + ", maxLevel=" + this.getMaxLevel() + ", fetchLastLevelOnly=" + this.isFetchLastLevelOnly() + ")";
    }

    @ConstructorProperties(value={"rootId", "rootType", "direction", "relationTypeGroup", "maxLevel", "fetchLastLevelOnly"})
    @Generated
    public RelationsSearchParameters(UUID rootId, EntityType rootType, EntitySearchDirection direction, RelationTypeGroup relationTypeGroup, int maxLevel, boolean fetchLastLevelOnly) {
        this.rootId = rootId;
        this.rootType = rootType;
        this.direction = direction;
        this.relationTypeGroup = relationTypeGroup;
        this.maxLevel = maxLevel;
        this.fetchLastLevelOnly = fetchLastLevelOnly;
    }
}

