/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.relation;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;

@Schema
public class RelationEntityTypeFilter {
    @Schema(description="Type of the relation between root entity and other entity (e.g. 'Contains' or 'Manages').", example="Contains")
    private String relationType;
    @Schema(description="Array of entity types to filter the related entities (e.g. 'DEVICE', 'ASSET').")
    private List<EntityType> entityTypes;
    @Schema(description="Negate relation type between root entity and other entity.")
    private boolean negate;

    public RelationEntityTypeFilter() {
    }

    public RelationEntityTypeFilter(String relationType, List<EntityType> entityTypes) {
        this(relationType, entityTypes, false);
    }

    public RelationEntityTypeFilter(String relationType, List<EntityType> entityTypes, boolean negate) {
        this.relationType = relationType;
        this.entityTypes = entityTypes;
        this.negate = negate;
    }

    @Generated
    public String getRelationType() {
        return this.relationType;
    }

    @Generated
    public List<EntityType> getEntityTypes() {
        return this.entityTypes;
    }

    @Generated
    public boolean isNegate() {
        return this.negate;
    }

    @Generated
    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    @Generated
    public void setEntityTypes(List<EntityType> entityTypes) {
        this.entityTypes = entityTypes;
    }

    @Generated
    public void setNegate(boolean negate) {
        this.negate = negate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationEntityTypeFilter)) {
            return false;
        }
        RelationEntityTypeFilter other = (RelationEntityTypeFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNegate() != other.isNegate()) {
            return false;
        }
        String this$relationType = this.getRelationType();
        String other$relationType = other.getRelationType();
        if (this$relationType == null ? other$relationType != null : !this$relationType.equals(other$relationType)) {
            return false;
        }
        List<EntityType> this$entityTypes = this.getEntityTypes();
        List<EntityType> other$entityTypes = other.getEntityTypes();
        return !(this$entityTypes == null ? other$entityTypes != null : !((Object)this$entityTypes).equals(other$entityTypes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RelationEntityTypeFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNegate() ? 79 : 97);
        String $relationType = this.getRelationType();
        result = result * 59 + ($relationType == null ? 43 : $relationType.hashCode());
        List<EntityType> $entityTypes = this.getEntityTypes();
        result = result * 59 + ($entityTypes == null ? 43 : ((Object)$entityTypes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RelationEntityTypeFilter(relationType=" + this.getRelationType() + ", entityTypes=" + String.valueOf(this.getEntityTypes()) + ", negate=" + this.isNegate() + ")";
    }
}

