/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.query.ComparisonTsValue;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.common.data.query.TsValue;

public class EntityData {
    private EntityId entityId;
    private Map<EntityKeyType, Map<String, TsValue>> latest;
    private Map<String, TsValue[]> timeseries;
    private Map<Integer, ComparisonTsValue> aggLatest;

    public EntityData(EntityId entityId, Map<EntityKeyType, Map<String, TsValue>> latest, Map<String, TsValue[]> timeseries) {
        this(entityId, latest, timeseries, null);
    }

    @JsonIgnore
    public void clearTsAndAggData() {
        if (this.timeseries != null) {
            this.timeseries.clear();
        }
        if (this.aggLatest != null) {
            this.aggLatest.clear();
        }
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public Map<EntityKeyType, Map<String, TsValue>> getLatest() {
        return this.latest;
    }

    @Generated
    public Map<String, TsValue[]> getTimeseries() {
        return this.timeseries;
    }

    @Generated
    public Map<Integer, ComparisonTsValue> getAggLatest() {
        return this.aggLatest;
    }

    @Generated
    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setLatest(Map<EntityKeyType, Map<String, TsValue>> latest) {
        this.latest = latest;
    }

    @Generated
    public void setTimeseries(Map<String, TsValue[]> timeseries) {
        this.timeseries = timeseries;
    }

    @Generated
    public void setAggLatest(Map<Integer, ComparisonTsValue> aggLatest) {
        this.aggLatest = aggLatest;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityData)) {
            return false;
        }
        EntityData other = (EntityData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        Map<EntityKeyType, Map<String, TsValue>> this$latest = this.getLatest();
        Map<EntityKeyType, Map<String, TsValue>> other$latest = other.getLatest();
        if (this$latest == null ? other$latest != null : !((Object)this$latest).equals(other$latest)) {
            return false;
        }
        Map<String, TsValue[]> this$timeseries = this.getTimeseries();
        Map<String, TsValue[]> other$timeseries = other.getTimeseries();
        if (this$timeseries == null ? other$timeseries != null : !((Object)this$timeseries).equals(other$timeseries)) {
            return false;
        }
        Map<Integer, ComparisonTsValue> this$aggLatest = this.getAggLatest();
        Map<Integer, ComparisonTsValue> other$aggLatest = other.getAggLatest();
        return !(this$aggLatest == null ? other$aggLatest != null : !((Object)this$aggLatest).equals(other$aggLatest));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        Map<EntityKeyType, Map<String, TsValue>> $latest = this.getLatest();
        result = result * 59 + ($latest == null ? 43 : ((Object)$latest).hashCode());
        Map<String, TsValue[]> $timeseries = this.getTimeseries();
        result = result * 59 + ($timeseries == null ? 43 : ((Object)$timeseries).hashCode());
        Map<Integer, ComparisonTsValue> $aggLatest = this.getAggLatest();
        result = result * 59 + ($aggLatest == null ? 43 : ((Object)$aggLatest).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntityData(entityId=" + String.valueOf(this.getEntityId()) + ", latest=" + String.valueOf(this.getLatest()) + ", timeseries=" + String.valueOf(this.getTimeseries()) + ", aggLatest=" + String.valueOf(this.getAggLatest()) + ")";
    }

    @ConstructorProperties(value={"entityId", "latest", "timeseries", "aggLatest"})
    @Generated
    public EntityData(EntityId entityId, Map<EntityKeyType, Map<String, TsValue>> latest, Map<String, TsValue[]> timeseries, Map<Integer, ComparisonTsValue> aggLatest) {
        this.entityId = entityId;
        this.latest = latest;
        this.timeseries = timeseries;
        this.aggLatest = aggLatest;
    }

    @Generated
    public EntityData() {
    }
}

