/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.query;

import java.util.UUID;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.query.AliasEntityId;
import org.thingsboard.server.common.data.query.AliasEntityType;

class AliasEntityIdImpl
implements AliasEntityId {
    private UUID id;
    private EntityType entityType;
    private AliasEntityType aliasEntityType;
    private EntityId defaultEntityId;

    protected AliasEntityIdImpl(EntityId entityId) {
        this.id = entityId.getId();
        this.entityType = entityId.getEntityType();
    }

    protected AliasEntityIdImpl(AliasEntityType aliasEntityType, UUID id) {
        this.aliasEntityType = aliasEntityType;
        if (id != null) {
            switch (this.aliasEntityType) {
                case CURRENT_CUSTOMER: {
                    this.defaultEntityId = new CustomerId(id);
                }
            }
        }
    }

    @Override
    public AliasEntityType getAliasEntityType() {
        return this.aliasEntityType;
    }

    @Override
    public EntityId defaultEntityId() {
        return this.defaultEntityId;
    }

    @Override
    public EntityId toEntityId() {
        return EntityIdFactory.getByTypeAndUuid(this.entityType, this.id);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    public boolean equals(Object obj) {
        AliasEntityId otherAliasEntityId;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityId)) {
            return false;
        }
        EntityId otherEntityId = (EntityId)obj;
        if (obj instanceof AliasEntityId && (otherAliasEntityId = (AliasEntityId)obj).isAliasEntityId()) {
            if (!this.isAliasEntityId()) {
                return false;
            }
            if (this.aliasEntityType != otherAliasEntityId.getAliasEntityType()) {
                return false;
            }
            if (this.defaultEntityId != null && !this.defaultEntityId.equals(otherAliasEntityId.defaultEntityId())) {
                return false;
            }
            if (this.defaultEntityId == null && otherAliasEntityId.defaultEntityId() != null) {
                return false;
            }
        }
        if (this.isAliasEntityId()) {
            return false;
        }
        if (this.id == null) {
            return otherEntityId.getId() == null;
        }
        return this.id.equals(otherEntityId.getId());
    }
}

