/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.plugin;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import lombok.Generated;

public enum ComponentLifecycleEvent implements Serializable
{
    CREATED(0),
    STARTED(1),
    ACTIVATED(2),
    SUSPENDED(3),
    UPDATED(4),
    STOPPED(5),
    DELETED(6),
    FAILED(7),
    DEACTIVATED(8);

    private final int protoNumber;
    private static final ComponentLifecycleEvent[] BY_PROTO;

    public static ComponentLifecycleEvent forProtoNumber(int protoNumber) {
        if (protoNumber < 0 || protoNumber >= BY_PROTO.length) {
            throw new IllegalArgumentException("Invalid ComponentLifecycleEvent proto number " + protoNumber);
        }
        return BY_PROTO[protoNumber];
    }

    @ConstructorProperties(value={"protoNumber"})
    @Generated
    private ComponentLifecycleEvent(int protoNumber) {
        this.protoNumber = protoNumber;
    }

    @Generated
    public int getProtoNumber() {
        return this.protoNumber;
    }

    static {
        BY_PROTO = new ComponentLifecycleEvent[Arrays.stream(ComponentLifecycleEvent.values()).mapToInt(ComponentLifecycleEvent::getProtoNumber).max().orElse(0) + 1];
        ComponentLifecycleEvent[] componentLifecycleEventArray = ComponentLifecycleEvent.values();
        int n = componentLifecycleEventArray.length;
        for (int i = 0; i < n; ++i) {
            ComponentLifecycleEvent event;
            ComponentLifecycleEvent.BY_PROTO[event.getProtoNumber()] = event = componentLifecycleEventArray[i];
        }
    }
}

