/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.id.ComponentDescriptorId;
import org.thingsboard.server.common.data.plugin.ComponentClusteringMode;
import org.thingsboard.server.common.data.plugin.ComponentScope;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.validation.Length;

@Schema
public class ComponentDescriptor
extends BaseData<ComponentDescriptorId> {
    private static final long serialVersionUID = 1L;
    @Schema(description="Type of the Rule Node", accessMode=Schema.AccessMode.READ_ONLY)
    private ComponentType type;
    @Schema(description="Scope of the Rule Node. Always set to 'TENANT', since no rule chains on the 'SYSTEM' level yet.", accessMode=Schema.AccessMode.READ_ONLY, allowableValues={"TENANT"}, example="TENANT")
    private ComponentScope scope;
    @Schema(description="Clustering mode of the RuleNode. This mode represents the ability to start Rule Node in multiple microservices.", accessMode=Schema.AccessMode.READ_ONLY, allowableValues={"USER_PREFERENCE", "ENABLED", "SINGLETON"}, example="ENABLED")
    private ComponentClusteringMode clusteringMode;
    @Length(fieldName="name")
    @Schema(description="Name of the Rule Node. Taken from the @RuleNode annotation.", accessMode=Schema.AccessMode.READ_ONLY, example="Custom Rule Node")
    private String name;
    @Schema(description="Full name of the Java class that implements the Rule Engine Node interface.", accessMode=Schema.AccessMode.READ_ONLY, example="com.mycompany.CustomRuleNode")
    private String clazz;
    @Schema(description="Complex JSON object that represents the Rule Node configuration.", accessMode=Schema.AccessMode.READ_ONLY)
    private transient JsonNode configurationDescriptor;
    @Schema(description="Rule node configuration version. By default, this value is 0. If the rule node is a versioned node, this value might be greater than 0.", accessMode=Schema.AccessMode.READ_ONLY)
    private int configurationVersion;
    @Length(fieldName="actions")
    @Schema(description="Rule Node Actions. Deprecated. Always null.", accessMode=Schema.AccessMode.READ_ONLY)
    private String actions;
    @Schema(description="Indicates that the RuleNode supports queue name configuration.", accessMode=Schema.AccessMode.READ_ONLY, example="true")
    private boolean hasQueueName;

    public ComponentDescriptor() {
    }

    public ComponentDescriptor(ComponentDescriptorId id) {
        super(id);
    }

    public ComponentDescriptor(ComponentDescriptor plugin) {
        super(plugin);
        this.type = plugin.getType();
        this.scope = plugin.getScope();
        this.clusteringMode = plugin.getClusteringMode();
        this.name = plugin.getName();
        this.clazz = plugin.getClazz();
        this.configurationDescriptor = plugin.getConfigurationDescriptor();
        this.configurationVersion = plugin.getConfigurationVersion();
        this.actions = plugin.getActions();
        this.hasQueueName = plugin.isHasQueueName();
    }

    @Override
    @Schema(description="JSON object with the descriptor Id. Specify existing descriptor id to update the descriptor. Referencing non-existing descriptor Id will cause error. Omit this field to create new descriptor.")
    public ComponentDescriptorId getId() {
        return (ComponentDescriptorId)super.getId();
    }

    @Override
    @Schema(description="Timestamp of the descriptor creation, in milliseconds", example="1609459200000", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTime() {
        return super.getCreatedTime();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentDescriptor that = (ComponentDescriptor)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.scope != that.scope) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.actions, that.actions)) {
            return false;
        }
        if (!Objects.equals(this.configurationDescriptor, that.configurationDescriptor)) {
            return false;
        }
        if (this.configurationVersion != that.configurationVersion) {
            return false;
        }
        if (this.clusteringMode != that.clusteringMode) {
            return false;
        }
        if (this.hasQueueName != that.isHasQueueName()) {
            return false;
        }
        return Objects.equals(this.clazz, that.clazz);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
        result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
        result = 31 * result + (this.clusteringMode != null ? this.clusteringMode.hashCode() : 0);
        result = 31 * result + (this.hasQueueName ? 1 : 0);
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ComponentDescriptor(type=" + String.valueOf((Object)this.getType()) + ", scope=" + String.valueOf((Object)this.getScope()) + ", clusteringMode=" + String.valueOf((Object)this.getClusteringMode()) + ", name=" + this.getName() + ", clazz=" + this.getClazz() + ", configurationDescriptor=" + String.valueOf(this.getConfigurationDescriptor()) + ", configurationVersion=" + this.getConfigurationVersion() + ", actions=" + this.getActions() + ", hasQueueName=" + this.isHasQueueName() + ")";
    }

    @Generated
    public ComponentType getType() {
        return this.type;
    }

    @Generated
    public void setType(ComponentType type) {
        this.type = type;
    }

    @Generated
    public ComponentScope getScope() {
        return this.scope;
    }

    @Generated
    public void setScope(ComponentScope scope) {
        this.scope = scope;
    }

    @Generated
    public ComponentClusteringMode getClusteringMode() {
        return this.clusteringMode;
    }

    @Generated
    public void setClusteringMode(ComponentClusteringMode clusteringMode) {
        this.clusteringMode = clusteringMode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getClazz() {
        return this.clazz;
    }

    @Generated
    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    @Generated
    public JsonNode getConfigurationDescriptor() {
        return this.configurationDescriptor;
    }

    @Generated
    public void setConfigurationDescriptor(JsonNode configurationDescriptor) {
        this.configurationDescriptor = configurationDescriptor;
    }

    @Generated
    public int getConfigurationVersion() {
        return this.configurationVersion;
    }

    @Generated
    public void setConfigurationVersion(int configurationVersion) {
        this.configurationVersion = configurationVersion;
    }

    @Generated
    public String getActions() {
        return this.actions;
    }

    @Generated
    public void setActions(String actions) {
        this.actions = actions;
    }

    @Generated
    public boolean isHasQueueName() {
        return this.hasQueueName;
    }

    @Generated
    public void setHasQueueName(boolean hasQueueName) {
        this.hasQueueName = hasQueueName;
    }
}

