/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.permission;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;

public class QueryContext {
    private final TenantId tenantId;
    private final CustomerId customerId;
    private final EntityType entityType;
    private final boolean ignorePermissionCheck;
    private final Map<UUID, UUID> relatedParentIdMap = new HashMap<UUID, UUID>();

    public QueryContext(TenantId tenantId, CustomerId customerId, EntityType entityType) {
        this(tenantId, customerId, entityType, false);
    }

    public boolean isTenantUser() {
        return this.customerId == null || this.customerId.isNullUid();
    }

    @ConstructorProperties(value={"tenantId", "customerId", "entityType", "ignorePermissionCheck"})
    @Generated
    public QueryContext(TenantId tenantId, CustomerId customerId, EntityType entityType, boolean ignorePermissionCheck) {
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.entityType = entityType;
        this.ignorePermissionCheck = ignorePermissionCheck;
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public CustomerId getCustomerId() {
        return this.customerId;
    }

    @Generated
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Generated
    public boolean isIgnorePermissionCheck() {
        return this.ignorePermissionCheck;
    }

    @Generated
    public Map<UUID, UUID> getRelatedParentIdMap() {
        return this.relatedParentIdMap;
    }
}

