/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.oauth2;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.thingsboard.server.common.data.oauth2.MapperType;
import org.thingsboard.server.common.data.oauth2.OAuth2BasicMapperConfig;
import org.thingsboard.server.common.data.oauth2.OAuth2CustomMapperConfig;

public class OAuth2MapperConfig {
    @Schema(description="Whether user should be created if not yet present on the platform after successful authentication")
    private boolean allowUserCreation;
    @Schema(description="Whether user credentials should be activated when user is created after successful authentication")
    private boolean activateUser;
    @Schema(description="Type of OAuth2 mapper. Depending on this param, different mapper config fields must be specified", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotNull
    private MapperType type;
    @Valid
    @Schema(description="Mapper config for BASIC and GITHUB mapper types")
    private OAuth2BasicMapperConfig basic;
    @Valid
    @Schema(description="Mapper config for CUSTOM mapper type")
    private OAuth2CustomMapperConfig custom;

    @ConstructorProperties(value={"allowUserCreation", "activateUser", "type", "basic", "custom"})
    @Generated
    OAuth2MapperConfig(boolean allowUserCreation, boolean activateUser, MapperType type, OAuth2BasicMapperConfig basic, OAuth2CustomMapperConfig custom) {
        this.allowUserCreation = allowUserCreation;
        this.activateUser = activateUser;
        this.type = type;
        this.basic = basic;
        this.custom = custom;
    }

    @Generated
    public static OAuth2MapperConfigBuilder builder() {
        return new OAuth2MapperConfigBuilder();
    }

    @Generated
    public OAuth2MapperConfigBuilder toBuilder() {
        return new OAuth2MapperConfigBuilder().allowUserCreation(this.allowUserCreation).activateUser(this.activateUser).type(this.type).basic(this.basic).custom(this.custom);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2MapperConfig)) {
            return false;
        }
        OAuth2MapperConfig other = (OAuth2MapperConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAllowUserCreation() != other.isAllowUserCreation()) {
            return false;
        }
        if (this.isActivateUser() != other.isActivateUser()) {
            return false;
        }
        MapperType this$type = this.getType();
        MapperType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        OAuth2BasicMapperConfig this$basic = this.getBasic();
        OAuth2BasicMapperConfig other$basic = other.getBasic();
        if (this$basic == null ? other$basic != null : !((Object)this$basic).equals(other$basic)) {
            return false;
        }
        OAuth2CustomMapperConfig this$custom = this.getCustom();
        OAuth2CustomMapperConfig other$custom = other.getCustom();
        return !(this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuth2MapperConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowUserCreation() ? 79 : 97);
        result = result * 59 + (this.isActivateUser() ? 79 : 97);
        MapperType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        OAuth2BasicMapperConfig $basic = this.getBasic();
        result = result * 59 + ($basic == null ? 43 : ((Object)$basic).hashCode());
        OAuth2CustomMapperConfig $custom = this.getCustom();
        result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
        return result;
    }

    @Generated
    public boolean isAllowUserCreation() {
        return this.allowUserCreation;
    }

    @Generated
    public boolean isActivateUser() {
        return this.activateUser;
    }

    @Generated
    public MapperType getType() {
        return this.type;
    }

    @Generated
    public OAuth2BasicMapperConfig getBasic() {
        return this.basic;
    }

    @Generated
    public OAuth2CustomMapperConfig getCustom() {
        return this.custom;
    }

    @Generated
    public void setAllowUserCreation(boolean allowUserCreation) {
        this.allowUserCreation = allowUserCreation;
    }

    @Generated
    public void setActivateUser(boolean activateUser) {
        this.activateUser = activateUser;
    }

    @Generated
    public void setType(MapperType type) {
        this.type = type;
    }

    @Generated
    public void setBasic(OAuth2BasicMapperConfig basic) {
        this.basic = basic;
    }

    @Generated
    public void setCustom(OAuth2CustomMapperConfig custom) {
        this.custom = custom;
    }

    @Generated
    public String toString() {
        return "OAuth2MapperConfig(allowUserCreation=" + this.isAllowUserCreation() + ", activateUser=" + this.isActivateUser() + ", type=" + String.valueOf((Object)this.getType()) + ", basic=" + String.valueOf(this.getBasic()) + ", custom=" + String.valueOf(this.getCustom()) + ")";
    }

    @Generated
    public static class OAuth2MapperConfigBuilder {
        @Generated
        private boolean allowUserCreation;
        @Generated
        private boolean activateUser;
        @Generated
        private MapperType type;
        @Generated
        private OAuth2BasicMapperConfig basic;
        @Generated
        private OAuth2CustomMapperConfig custom;

        @Generated
        OAuth2MapperConfigBuilder() {
        }

        @Generated
        public OAuth2MapperConfigBuilder allowUserCreation(boolean allowUserCreation) {
            this.allowUserCreation = allowUserCreation;
            return this;
        }

        @Generated
        public OAuth2MapperConfigBuilder activateUser(boolean activateUser) {
            this.activateUser = activateUser;
            return this;
        }

        @Generated
        public OAuth2MapperConfigBuilder type(MapperType type) {
            this.type = type;
            return this;
        }

        @Generated
        public OAuth2MapperConfigBuilder basic(OAuth2BasicMapperConfig basic) {
            this.basic = basic;
            return this;
        }

        @Generated
        public OAuth2MapperConfigBuilder custom(OAuth2CustomMapperConfig custom) {
            this.custom = custom;
            return this;
        }

        @Generated
        public OAuth2MapperConfig build() {
            return new OAuth2MapperConfig(this.allowUserCreation, this.activateUser, this.type, this.basic, this.custom);
        }

        @Generated
        public String toString() {
            return "OAuth2MapperConfig.OAuth2MapperConfigBuilder(allowUserCreation=" + this.allowUserCreation + ", activateUser=" + this.activateUser + ", type=" + String.valueOf((Object)this.type) + ", basic=" + String.valueOf(this.basic) + ", custom=" + String.valueOf(this.custom) + ")";
        }
    }
}

