/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.targets.slack;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.thingsboard.server.common.data.notification.targets.NotificationRecipient;
import org.thingsboard.server.common.data.notification.targets.slack.SlackConversationType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SlackConversation
implements NotificationRecipient {
    @NotNull
    private SlackConversationType type;
    @NotEmpty
    private String id;
    @NotEmpty
    private String name;
    private String wholeName;
    private String email;

    @Override
    public String getTitle() {
        if (this.type == SlackConversationType.DIRECT) {
            return (String)StringUtils.defaultIfEmpty((CharSequence)this.wholeName, (CharSequence)this.name);
        }
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getFirstName() {
        String firstName;
        String string = firstName = StringUtils.contains((CharSequence)this.wholeName, (CharSequence)" ") ? this.wholeName.split(" ")[0] : this.wholeName;
        if (StringUtils.isEmpty((CharSequence)firstName)) {
            firstName = this.name;
        }
        return firstName;
    }

    @Override
    @JsonIgnore
    public String getLastName() {
        return StringUtils.contains((CharSequence)this.wholeName, (CharSequence)" ") ? this.wholeName.split(" ")[1] : null;
    }

    @JsonIgnore
    public String getPointer() {
        return this.type == SlackConversationType.DIRECT ? "@" : "#";
    }

    @Generated
    public static SlackConversationBuilder builder() {
        return new SlackConversationBuilder();
    }

    @Generated
    public SlackConversationType getType() {
        return this.type;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getWholeName() {
        return this.wholeName;
    }

    @Override
    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public void setType(SlackConversationType type) {
        this.type = type;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setWholeName(String wholeName) {
        this.wholeName = wholeName;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlackConversation)) {
            return false;
        }
        SlackConversation other = (SlackConversation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SlackConversationType this$type = this.getType();
        SlackConversationType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$wholeName = this.getWholeName();
        String other$wholeName = other.getWholeName();
        if (this$wholeName == null ? other$wholeName != null : !this$wholeName.equals(other$wholeName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        return !(this$email == null ? other$email != null : !this$email.equals(other$email));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SlackConversation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SlackConversationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $wholeName = this.getWholeName();
        result = result * 59 + ($wholeName == null ? 43 : $wholeName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SlackConversation(type=" + String.valueOf((Object)this.getType()) + ", id=" + this.getId() + ", name=" + this.getName() + ", wholeName=" + this.getWholeName() + ", email=" + this.getEmail() + ")";
    }

    @Generated
    public SlackConversation() {
    }

    @ConstructorProperties(value={"type", "id", "name", "wholeName", "email"})
    @Generated
    public SlackConversation(SlackConversationType type, String id, String name, String wholeName, String email) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.wholeName = wholeName;
        this.email = email;
    }

    @Generated
    public static class SlackConversationBuilder {
        @Generated
        private SlackConversationType type;
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String wholeName;
        @Generated
        private String email;

        @Generated
        SlackConversationBuilder() {
        }

        @Generated
        public SlackConversationBuilder type(SlackConversationType type) {
            this.type = type;
            return this;
        }

        @Generated
        public SlackConversationBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public SlackConversationBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public SlackConversationBuilder wholeName(String wholeName) {
            this.wholeName = wholeName;
            return this;
        }

        @Generated
        public SlackConversationBuilder email(String email) {
            this.email = email;
            return this;
        }

        @Generated
        public SlackConversation build() {
            return new SlackConversation(this.type, this.id, this.name, this.wholeName, this.email);
        }

        @Generated
        public String toString() {
            return "SlackConversation.SlackConversationBuilder(type=" + String.valueOf((Object)this.type) + ", id=" + this.id + ", name=" + this.name + ", wholeName=" + this.wholeName + ", email=" + this.email + ")";
        }
    }
}

