/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.rule.trigger;

import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;

public class RateLimitsTrigger
implements NotificationRuleTrigger {
    private static final long serialVersionUID = -4423112145409424886L;
    private final TenantId tenantId;
    private final LimitedApi api;
    private final EntityId limitLevel;
    private final String limitLevelEntityName;

    @Override
    public NotificationRuleTriggerType getType() {
        return NotificationRuleTriggerType.RATE_LIMITS;
    }

    @Override
    public EntityId getOriginatorEntityId() {
        return this.limitLevel != null ? this.limitLevel : this.tenantId;
    }

    @Override
    public NotificationRuleTrigger.DeduplicationStrategy getDeduplicationStrategy() {
        return NotificationRuleTrigger.DeduplicationStrategy.ALL;
    }

    @Override
    public String getDeduplicationKey() {
        return String.join((CharSequence)":", NotificationRuleTrigger.super.getDeduplicationKey(), this.api.toString());
    }

    @Override
    public long getDefaultDeduplicationDuration() {
        return TimeUnit.HOURS.toMillis(4L);
    }

    @ConstructorProperties(value={"tenantId", "api", "limitLevel", "limitLevelEntityName"})
    @Generated
    RateLimitsTrigger(TenantId tenantId, LimitedApi api, EntityId limitLevel, String limitLevelEntityName) {
        this.tenantId = tenantId;
        this.api = api;
        this.limitLevel = limitLevel;
        this.limitLevelEntityName = limitLevelEntityName;
    }

    @Generated
    public static RateLimitsTriggerBuilder builder() {
        return new RateLimitsTriggerBuilder();
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public LimitedApi getApi() {
        return this.api;
    }

    @Generated
    public EntityId getLimitLevel() {
        return this.limitLevel;
    }

    @Generated
    public String getLimitLevelEntityName() {
        return this.limitLevelEntityName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RateLimitsTrigger)) {
            return false;
        }
        RateLimitsTrigger other = (RateLimitsTrigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        LimitedApi this$api = this.getApi();
        LimitedApi other$api = other.getApi();
        if (this$api == null ? other$api != null : !((Object)((Object)this$api)).equals((Object)other$api)) {
            return false;
        }
        EntityId this$limitLevel = this.getLimitLevel();
        EntityId other$limitLevel = other.getLimitLevel();
        if (this$limitLevel == null ? other$limitLevel != null : !this$limitLevel.equals(other$limitLevel)) {
            return false;
        }
        String this$limitLevelEntityName = this.getLimitLevelEntityName();
        String other$limitLevelEntityName = other.getLimitLevelEntityName();
        return !(this$limitLevelEntityName == null ? other$limitLevelEntityName != null : !this$limitLevelEntityName.equals(other$limitLevelEntityName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RateLimitsTrigger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        LimitedApi $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : ((Object)((Object)$api)).hashCode());
        EntityId $limitLevel = this.getLimitLevel();
        result = result * 59 + ($limitLevel == null ? 43 : $limitLevel.hashCode());
        String $limitLevelEntityName = this.getLimitLevelEntityName();
        result = result * 59 + ($limitLevelEntityName == null ? 43 : $limitLevelEntityName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RateLimitsTrigger(tenantId=" + String.valueOf(this.getTenantId()) + ", api=" + String.valueOf((Object)this.getApi()) + ", limitLevel=" + String.valueOf(this.getLimitLevel()) + ", limitLevelEntityName=" + this.getLimitLevelEntityName() + ")";
    }

    @Generated
    public static class RateLimitsTriggerBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private LimitedApi api;
        @Generated
        private EntityId limitLevel;
        @Generated
        private String limitLevelEntityName;

        @Generated
        RateLimitsTriggerBuilder() {
        }

        @Generated
        public RateLimitsTriggerBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public RateLimitsTriggerBuilder api(LimitedApi api) {
            this.api = api;
            return this;
        }

        @Generated
        public RateLimitsTriggerBuilder limitLevel(EntityId limitLevel) {
            this.limitLevel = limitLevel;
            return this;
        }

        @Generated
        public RateLimitsTriggerBuilder limitLevelEntityName(String limitLevelEntityName) {
            this.limitLevelEntityName = limitLevelEntityName;
            return this;
        }

        @Generated
        public RateLimitsTrigger build() {
            return new RateLimitsTrigger(this.tenantId, this.api, this.limitLevel, this.limitLevelEntityName);
        }

        @Generated
        public String toString() {
            return "RateLimitsTrigger.RateLimitsTriggerBuilder(tenantId=" + String.valueOf(this.tenantId) + ", api=" + String.valueOf((Object)this.api) + ", limitLevel=" + String.valueOf(this.limitLevel) + ", limitLevelEntityName=" + this.limitLevelEntityName + ")";
        }
    }
}

