/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification.info;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;

public class RuleEngineOriginatedNotificationInfo
implements RuleOriginatedNotificationInfo {
    private EntityId msgOriginator;
    private CustomerId msgCustomerId;
    private String msgType;
    private Map<String, String> msgMetadata;
    private Map<String, String> msgData;

    @Override
    public Map<String, String> getTemplateData() {
        HashMap<String, String> templateData = new HashMap<String, String>();
        templateData.putAll(this.msgMetadata);
        templateData.putAll(this.msgData);
        templateData.put("originatorType", this.msgOriginator.getEntityType().getNormalName());
        templateData.put("originatorId", this.msgOriginator.getId().toString());
        templateData.put("msgType", this.msgType);
        templateData.put("customerId", this.msgCustomerId != null ? this.msgCustomerId.getId().toString() : "");
        return templateData;
    }

    @Override
    public EntityId getStateEntityId() {
        return this.msgOriginator;
    }

    @Override
    public CustomerId getAffectedCustomerId() {
        return this.msgCustomerId;
    }

    @Generated
    public static RuleEngineOriginatedNotificationInfoBuilder builder() {
        return new RuleEngineOriginatedNotificationInfoBuilder();
    }

    @Generated
    public EntityId getMsgOriginator() {
        return this.msgOriginator;
    }

    @Generated
    public CustomerId getMsgCustomerId() {
        return this.msgCustomerId;
    }

    @Generated
    public String getMsgType() {
        return this.msgType;
    }

    @Generated
    public Map<String, String> getMsgMetadata() {
        return this.msgMetadata;
    }

    @Generated
    public Map<String, String> getMsgData() {
        return this.msgData;
    }

    @Generated
    public void setMsgOriginator(EntityId msgOriginator) {
        this.msgOriginator = msgOriginator;
    }

    @Generated
    public void setMsgCustomerId(CustomerId msgCustomerId) {
        this.msgCustomerId = msgCustomerId;
    }

    @Generated
    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    @Generated
    public void setMsgMetadata(Map<String, String> msgMetadata) {
        this.msgMetadata = msgMetadata;
    }

    @Generated
    public void setMsgData(Map<String, String> msgData) {
        this.msgData = msgData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleEngineOriginatedNotificationInfo)) {
            return false;
        }
        RuleEngineOriginatedNotificationInfo other = (RuleEngineOriginatedNotificationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityId this$msgOriginator = this.getMsgOriginator();
        EntityId other$msgOriginator = other.getMsgOriginator();
        if (this$msgOriginator == null ? other$msgOriginator != null : !this$msgOriginator.equals(other$msgOriginator)) {
            return false;
        }
        CustomerId this$msgCustomerId = this.getMsgCustomerId();
        CustomerId other$msgCustomerId = other.getMsgCustomerId();
        if (this$msgCustomerId == null ? other$msgCustomerId != null : !((Object)this$msgCustomerId).equals(other$msgCustomerId)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        Map<String, String> this$msgMetadata = this.getMsgMetadata();
        Map<String, String> other$msgMetadata = other.getMsgMetadata();
        if (this$msgMetadata == null ? other$msgMetadata != null : !((Object)this$msgMetadata).equals(other$msgMetadata)) {
            return false;
        }
        Map<String, String> this$msgData = this.getMsgData();
        Map<String, String> other$msgData = other.getMsgData();
        return !(this$msgData == null ? other$msgData != null : !((Object)this$msgData).equals(other$msgData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RuleEngineOriginatedNotificationInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityId $msgOriginator = this.getMsgOriginator();
        result = result * 59 + ($msgOriginator == null ? 43 : $msgOriginator.hashCode());
        CustomerId $msgCustomerId = this.getMsgCustomerId();
        result = result * 59 + ($msgCustomerId == null ? 43 : ((Object)$msgCustomerId).hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        Map<String, String> $msgMetadata = this.getMsgMetadata();
        result = result * 59 + ($msgMetadata == null ? 43 : ((Object)$msgMetadata).hashCode());
        Map<String, String> $msgData = this.getMsgData();
        result = result * 59 + ($msgData == null ? 43 : ((Object)$msgData).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RuleEngineOriginatedNotificationInfo(msgOriginator=" + String.valueOf(this.getMsgOriginator()) + ", msgCustomerId=" + String.valueOf(this.getMsgCustomerId()) + ", msgType=" + this.getMsgType() + ", msgMetadata=" + String.valueOf(this.getMsgMetadata()) + ", msgData=" + String.valueOf(this.getMsgData()) + ")";
    }

    @ConstructorProperties(value={"msgOriginator", "msgCustomerId", "msgType", "msgMetadata", "msgData"})
    @Generated
    public RuleEngineOriginatedNotificationInfo(EntityId msgOriginator, CustomerId msgCustomerId, String msgType, Map<String, String> msgMetadata, Map<String, String> msgData) {
        this.msgOriginator = msgOriginator;
        this.msgCustomerId = msgCustomerId;
        this.msgType = msgType;
        this.msgMetadata = msgMetadata;
        this.msgData = msgData;
    }

    @Generated
    public RuleEngineOriginatedNotificationInfo() {
    }

    @Generated
    public static class RuleEngineOriginatedNotificationInfoBuilder {
        @Generated
        private EntityId msgOriginator;
        @Generated
        private CustomerId msgCustomerId;
        @Generated
        private String msgType;
        @Generated
        private Map<String, String> msgMetadata;
        @Generated
        private Map<String, String> msgData;

        @Generated
        RuleEngineOriginatedNotificationInfoBuilder() {
        }

        @Generated
        public RuleEngineOriginatedNotificationInfoBuilder msgOriginator(EntityId msgOriginator) {
            this.msgOriginator = msgOriginator;
            return this;
        }

        @Generated
        public RuleEngineOriginatedNotificationInfoBuilder msgCustomerId(CustomerId msgCustomerId) {
            this.msgCustomerId = msgCustomerId;
            return this;
        }

        @Generated
        public RuleEngineOriginatedNotificationInfoBuilder msgType(String msgType) {
            this.msgType = msgType;
            return this;
        }

        @Generated
        public RuleEngineOriginatedNotificationInfoBuilder msgMetadata(Map<String, String> msgMetadata) {
            this.msgMetadata = msgMetadata;
            return this;
        }

        @Generated
        public RuleEngineOriginatedNotificationInfoBuilder msgData(Map<String, String> msgData) {
            this.msgData = msgData;
            return this;
        }

        @Generated
        public RuleEngineOriginatedNotificationInfo build() {
            return new RuleEngineOriginatedNotificationInfo(this.msgOriginator, this.msgCustomerId, this.msgType, this.msgMetadata, this.msgData);
        }

        @Generated
        public String toString() {
            return "RuleEngineOriginatedNotificationInfo.RuleEngineOriginatedNotificationInfoBuilder(msgOriginator=" + String.valueOf(this.msgOriginator) + ", msgCustomerId=" + String.valueOf(this.msgCustomerId) + ", msgType=" + this.msgType + ", msgMetadata=" + String.valueOf(this.msgMetadata) + ", msgData=" + String.valueOf(this.msgData) + ")";
        }
    }
}

