/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.thingsboard.server.common.data.notification.AlreadySentException;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.targets.NotificationRecipient;

public class NotificationRequestStats {
    private final Map<NotificationDeliveryMethod, AtomicInteger> sent;
    @JsonIgnore
    private final AtomicInteger totalSent;
    private final Map<NotificationDeliveryMethod, Map<String, String>> errors;
    private final AtomicInteger totalErrors;
    private String error;
    @JsonIgnore
    private final Map<NotificationDeliveryMethod, Set<Object>> processedRecipients;

    public NotificationRequestStats() {
        this.sent = new ConcurrentHashMap<NotificationDeliveryMethod, AtomicInteger>();
        this.totalSent = new AtomicInteger();
        this.errors = new ConcurrentHashMap<NotificationDeliveryMethod, Map<String, String>>();
        this.totalErrors = new AtomicInteger();
        this.processedRecipients = new ConcurrentHashMap<NotificationDeliveryMethod, Set<Object>>();
    }

    @JsonCreator
    public NotificationRequestStats(@JsonProperty(value="sent") Map<NotificationDeliveryMethod, AtomicInteger> sent, @JsonProperty(value="errors") Map<NotificationDeliveryMethod, Map<String, String>> errors, @JsonProperty(value="totalErrors") Integer totalErrors, @JsonProperty(value="error") String error) {
        this.sent = sent;
        this.totalSent = null;
        this.errors = errors;
        if (totalErrors == null) {
            totalErrors = errors != null ? Integer.valueOf(errors.values().stream().mapToInt(Map::size).sum()) : Integer.valueOf(0);
        }
        this.totalErrors = new AtomicInteger(totalErrors);
        this.error = error;
        this.processedRecipients = Collections.emptyMap();
    }

    public void reportSent(NotificationDeliveryMethod deliveryMethod, NotificationRecipient recipient) {
        this.sent.computeIfAbsent(deliveryMethod, k -> new AtomicInteger()).incrementAndGet();
        this.totalSent.incrementAndGet();
    }

    public void reportError(NotificationDeliveryMethod deliveryMethod, Throwable error, NotificationRecipient recipient) {
        Map errors;
        if (error instanceof AlreadySentException) {
            return;
        }
        String errorMessage = error.getMessage();
        if (errorMessage == null) {
            errorMessage = error.getClass().getSimpleName();
        }
        if ((errors = this.errors.computeIfAbsent(deliveryMethod, k -> new ConcurrentHashMap())).size() < 100) {
            errors.put(recipient.getTitle(), errorMessage);
        }
        this.totalErrors.incrementAndGet();
    }

    public void reportProcessed(NotificationDeliveryMethod deliveryMethod, Object recipientId) {
        this.processedRecipients.computeIfAbsent(deliveryMethod, k -> ConcurrentHashMap.newKeySet()).add(recipientId);
    }

    public boolean contains(NotificationDeliveryMethod deliveryMethod, Object recipientId) {
        Set<Object> processedRecipients = this.processedRecipients.get((Object)deliveryMethod);
        return processedRecipients != null && processedRecipients.contains(recipientId);
    }

    @Generated
    public Map<NotificationDeliveryMethod, AtomicInteger> getSent() {
        return this.sent;
    }

    @Generated
    public AtomicInteger getTotalSent() {
        return this.totalSent;
    }

    @Generated
    public Map<NotificationDeliveryMethod, Map<String, String>> getErrors() {
        return this.errors;
    }

    @Generated
    public AtomicInteger getTotalErrors() {
        return this.totalErrors;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public Map<NotificationDeliveryMethod, Set<Object>> getProcessedRecipients() {
        return this.processedRecipients;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationRequestStats)) {
            return false;
        }
        NotificationRequestStats other = (NotificationRequestStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<NotificationDeliveryMethod, AtomicInteger> this$sent = this.getSent();
        Map<NotificationDeliveryMethod, AtomicInteger> other$sent = other.getSent();
        if (this$sent == null ? other$sent != null : !((Object)this$sent).equals(other$sent)) {
            return false;
        }
        AtomicInteger this$totalSent = this.getTotalSent();
        AtomicInteger other$totalSent = other.getTotalSent();
        if (this$totalSent == null ? other$totalSent != null : !this$totalSent.equals(other$totalSent)) {
            return false;
        }
        Map<NotificationDeliveryMethod, Map<String, String>> this$errors = this.getErrors();
        Map<NotificationDeliveryMethod, Map<String, String>> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        AtomicInteger this$totalErrors = this.getTotalErrors();
        AtomicInteger other$totalErrors = other.getTotalErrors();
        if (this$totalErrors == null ? other$totalErrors != null : !this$totalErrors.equals(other$totalErrors)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        Map<NotificationDeliveryMethod, Set<Object>> this$processedRecipients = this.getProcessedRecipients();
        Map<NotificationDeliveryMethod, Set<Object>> other$processedRecipients = other.getProcessedRecipients();
        return !(this$processedRecipients == null ? other$processedRecipients != null : !((Object)this$processedRecipients).equals(other$processedRecipients));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NotificationRequestStats;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<NotificationDeliveryMethod, AtomicInteger> $sent = this.getSent();
        result = result * 59 + ($sent == null ? 43 : ((Object)$sent).hashCode());
        AtomicInteger $totalSent = this.getTotalSent();
        result = result * 59 + ($totalSent == null ? 43 : $totalSent.hashCode());
        Map<NotificationDeliveryMethod, Map<String, String>> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        AtomicInteger $totalErrors = this.getTotalErrors();
        result = result * 59 + ($totalErrors == null ? 43 : $totalErrors.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        Map<NotificationDeliveryMethod, Set<Object>> $processedRecipients = this.getProcessedRecipients();
        result = result * 59 + ($processedRecipients == null ? 43 : ((Object)$processedRecipients).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NotificationRequestStats(sent=" + String.valueOf(this.getSent()) + ", totalSent=" + String.valueOf(this.getTotalSent()) + ", errors=" + String.valueOf(this.getErrors()) + ", totalErrors=" + String.valueOf(this.getTotalErrors()) + ", error=" + this.getError() + ", processedRecipients=" + String.valueOf(this.getProcessedRecipients()) + ")";
    }
}

