/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.notification;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.NotificationRequestId;
import org.thingsboard.server.common.data.id.NotificationRuleId;
import org.thingsboard.server.common.data.id.NotificationTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.notification.NotificationRequestConfig;
import org.thingsboard.server.common.data.notification.NotificationRequestStats;
import org.thingsboard.server.common.data.notification.NotificationRequestStatus;
import org.thingsboard.server.common.data.notification.info.NotificationInfo;
import org.thingsboard.server.common.data.notification.template.NotificationTemplate;

public class NotificationRequest
extends BaseData<NotificationRequestId>
implements HasTenantId,
HasName {
    private TenantId tenantId;
    @NotEmpty
    private List<UUID> targets;
    private NotificationTemplateId templateId;
    @Valid
    private NotificationTemplate template;
    @Valid
    private NotificationInfo info;
    @Valid
    private NotificationRequestConfig additionalConfig;
    private EntityId originatorEntityId;
    private NotificationRuleId ruleId;
    private NotificationRequestStatus status;
    private NotificationRequestStats stats;

    public NotificationRequest(NotificationRequest other) {
        super(other);
        this.tenantId = other.tenantId;
        this.targets = other.targets;
        this.templateId = other.templateId;
        this.template = other.template;
        this.info = other.info;
        this.additionalConfig = other.additionalConfig;
        this.originatorEntityId = other.originatorEntityId;
        this.ruleId = other.ruleId;
        this.status = other.status;
        this.stats = other.stats;
    }

    @Override
    @JsonIgnore
    public String getName() {
        return "To targets " + String.valueOf(this.targets);
    }

    @JsonIgnore
    public UserId getSenderId() {
        return this.originatorEntityId instanceof UserId ? (UserId)this.originatorEntityId : null;
    }

    @JsonIgnore
    public boolean isSent() {
        return this.status == NotificationRequestStatus.SENT;
    }

    @JsonIgnore
    public boolean isScheduled() {
        return this.status == NotificationRequestStatus.SCHEDULED;
    }

    @Generated
    public static NotificationRequestBuilder builder() {
        return new NotificationRequestBuilder();
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public List<UUID> getTargets() {
        return this.targets;
    }

    @Generated
    public NotificationTemplateId getTemplateId() {
        return this.templateId;
    }

    @Generated
    public NotificationTemplate getTemplate() {
        return this.template;
    }

    @Generated
    public NotificationInfo getInfo() {
        return this.info;
    }

    @Generated
    public NotificationRequestConfig getAdditionalConfig() {
        return this.additionalConfig;
    }

    @Generated
    public EntityId getOriginatorEntityId() {
        return this.originatorEntityId;
    }

    @Generated
    public NotificationRuleId getRuleId() {
        return this.ruleId;
    }

    @Generated
    public NotificationRequestStatus getStatus() {
        return this.status;
    }

    @Generated
    public NotificationRequestStats getStats() {
        return this.stats;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setTargets(List<UUID> targets) {
        this.targets = targets;
    }

    @Generated
    public void setTemplateId(NotificationTemplateId templateId) {
        this.templateId = templateId;
    }

    @Generated
    public void setTemplate(NotificationTemplate template) {
        this.template = template;
    }

    @Generated
    public void setInfo(NotificationInfo info) {
        this.info = info;
    }

    @Generated
    public void setAdditionalConfig(NotificationRequestConfig additionalConfig) {
        this.additionalConfig = additionalConfig;
    }

    @Generated
    public void setOriginatorEntityId(EntityId originatorEntityId) {
        this.originatorEntityId = originatorEntityId;
    }

    @Generated
    public void setRuleId(NotificationRuleId ruleId) {
        this.ruleId = ruleId;
    }

    @Generated
    public void setStatus(NotificationRequestStatus status) {
        this.status = status;
    }

    @Generated
    public void setStats(NotificationRequestStats stats) {
        this.stats = stats;
    }

    @Override
    @Generated
    public String toString() {
        return "NotificationRequest(tenantId=" + String.valueOf(this.getTenantId()) + ", targets=" + String.valueOf(this.getTargets()) + ", templateId=" + String.valueOf(this.getTemplateId()) + ", template=" + String.valueOf(this.getTemplate()) + ", info=" + String.valueOf(this.getInfo()) + ", additionalConfig=" + String.valueOf(this.getAdditionalConfig()) + ", originatorEntityId=" + String.valueOf(this.getOriginatorEntityId()) + ", ruleId=" + String.valueOf(this.getRuleId()) + ", status=" + String.valueOf((Object)this.getStatus()) + ", stats=" + String.valueOf(this.getStats()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationRequest)) {
            return false;
        }
        NotificationRequest other = (NotificationRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        List<UUID> this$targets = this.getTargets();
        List<UUID> other$targets = other.getTargets();
        if (this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets)) {
            return false;
        }
        NotificationTemplateId this$templateId = this.getTemplateId();
        NotificationTemplateId other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !((Object)this$templateId).equals(other$templateId)) {
            return false;
        }
        NotificationTemplate this$template = this.getTemplate();
        NotificationTemplate other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        NotificationInfo this$info = this.getInfo();
        NotificationInfo other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
            return false;
        }
        NotificationRequestConfig this$additionalConfig = this.getAdditionalConfig();
        NotificationRequestConfig other$additionalConfig = other.getAdditionalConfig();
        if (this$additionalConfig == null ? other$additionalConfig != null : !((Object)this$additionalConfig).equals(other$additionalConfig)) {
            return false;
        }
        EntityId this$originatorEntityId = this.getOriginatorEntityId();
        EntityId other$originatorEntityId = other.getOriginatorEntityId();
        if (this$originatorEntityId == null ? other$originatorEntityId != null : !this$originatorEntityId.equals(other$originatorEntityId)) {
            return false;
        }
        NotificationRuleId this$ruleId = this.getRuleId();
        NotificationRuleId other$ruleId = other.getRuleId();
        if (this$ruleId == null ? other$ruleId != null : !((Object)this$ruleId).equals(other$ruleId)) {
            return false;
        }
        NotificationRequestStatus this$status = this.getStatus();
        NotificationRequestStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        NotificationRequestStats this$stats = this.getStats();
        NotificationRequestStats other$stats = other.getStats();
        return !(this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NotificationRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        List<UUID> $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
        NotificationTemplateId $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : ((Object)$templateId).hashCode());
        NotificationTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        NotificationInfo $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        NotificationRequestConfig $additionalConfig = this.getAdditionalConfig();
        result = result * 59 + ($additionalConfig == null ? 43 : ((Object)$additionalConfig).hashCode());
        EntityId $originatorEntityId = this.getOriginatorEntityId();
        result = result * 59 + ($originatorEntityId == null ? 43 : $originatorEntityId.hashCode());
        NotificationRuleId $ruleId = this.getRuleId();
        result = result * 59 + ($ruleId == null ? 43 : ((Object)$ruleId).hashCode());
        NotificationRequestStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        NotificationRequestStats $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        return result;
    }

    @Generated
    public NotificationRequest() {
    }

    @ConstructorProperties(value={"tenantId", "targets", "templateId", "template", "info", "additionalConfig", "originatorEntityId", "ruleId", "status", "stats"})
    @Generated
    public NotificationRequest(TenantId tenantId, List<UUID> targets, NotificationTemplateId templateId, NotificationTemplate template, NotificationInfo info, NotificationRequestConfig additionalConfig, EntityId originatorEntityId, NotificationRuleId ruleId, NotificationRequestStatus status, NotificationRequestStats stats) {
        this.tenantId = tenantId;
        this.targets = targets;
        this.templateId = templateId;
        this.template = template;
        this.info = info;
        this.additionalConfig = additionalConfig;
        this.originatorEntityId = originatorEntityId;
        this.ruleId = ruleId;
        this.status = status;
        this.stats = stats;
    }

    @Generated
    public static class NotificationRequestBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private List<UUID> targets;
        @Generated
        private NotificationTemplateId templateId;
        @Generated
        private NotificationTemplate template;
        @Generated
        private NotificationInfo info;
        @Generated
        private NotificationRequestConfig additionalConfig;
        @Generated
        private EntityId originatorEntityId;
        @Generated
        private NotificationRuleId ruleId;
        @Generated
        private NotificationRequestStatus status;
        @Generated
        private NotificationRequestStats stats;

        @Generated
        NotificationRequestBuilder() {
        }

        @Generated
        public NotificationRequestBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public NotificationRequestBuilder targets(List<UUID> targets) {
            this.targets = targets;
            return this;
        }

        @Generated
        public NotificationRequestBuilder templateId(NotificationTemplateId templateId) {
            this.templateId = templateId;
            return this;
        }

        @Generated
        public NotificationRequestBuilder template(NotificationTemplate template) {
            this.template = template;
            return this;
        }

        @Generated
        public NotificationRequestBuilder info(NotificationInfo info) {
            this.info = info;
            return this;
        }

        @Generated
        public NotificationRequestBuilder additionalConfig(NotificationRequestConfig additionalConfig) {
            this.additionalConfig = additionalConfig;
            return this;
        }

        @Generated
        public NotificationRequestBuilder originatorEntityId(EntityId originatorEntityId) {
            this.originatorEntityId = originatorEntityId;
            return this;
        }

        @Generated
        public NotificationRequestBuilder ruleId(NotificationRuleId ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        @Generated
        public NotificationRequestBuilder status(NotificationRequestStatus status) {
            this.status = status;
            return this;
        }

        @Generated
        public NotificationRequestBuilder stats(NotificationRequestStats stats) {
            this.stats = stats;
            return this;
        }

        @Generated
        public NotificationRequest build() {
            return new NotificationRequest(this.tenantId, this.targets, this.templateId, this.template, this.info, this.additionalConfig, this.originatorEntityId, this.ruleId, this.status, this.stats);
        }

        @Generated
        public String toString() {
            return "NotificationRequest.NotificationRequestBuilder(tenantId=" + String.valueOf(this.tenantId) + ", targets=" + String.valueOf(this.targets) + ", templateId=" + String.valueOf(this.templateId) + ", template=" + String.valueOf(this.template) + ", info=" + String.valueOf(this.info) + ", additionalConfig=" + String.valueOf(this.additionalConfig) + ", originatorEntityId=" + String.valueOf(this.originatorEntityId) + ", ruleId=" + String.valueOf(this.ruleId) + ", status=" + String.valueOf((Object)this.status) + ", stats=" + String.valueOf(this.stats) + ")";
        }
    }
}

