/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.mobile.bundle;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.MobileAppBundleId;
import org.thingsboard.server.common.data.id.MobileAppId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.mobile.layout.MobileLayoutConfig;
import org.thingsboard.server.common.data.validation.Length;
import org.thingsboard.server.common.data.validation.NoXss;

public class MobileAppBundle
extends BaseData<MobileAppBundleId>
implements HasTenantId,
HasName {
    @Schema(description="JSON object with Tenant Id")
    private TenantId tenantId;
    @Schema(description="Application bundle title. Cannot be empty", requiredMode=Schema.RequiredMode.REQUIRED)
    @NotBlank
    @NoXss
    @Length(fieldName="title")
    private String title;
    @Schema(description="Application bundle description.")
    @NoXss
    @Length(fieldName="description")
    private String description;
    @Schema(description="Android application id")
    private MobileAppId androidAppId;
    @Schema(description="IOS application id")
    private MobileAppId iosAppId;
    @Schema(description="Application layout configuration")
    @Valid
    private MobileLayoutConfig layoutConfig;
    @Schema(description="Whether OAuth2 settings are enabled or not")
    private Boolean oauth2Enabled;

    public MobileAppBundle() {
    }

    public MobileAppBundle(MobileAppBundleId id) {
        super(id);
    }

    public MobileAppBundle(MobileAppBundle mobile) {
        super(mobile);
        this.tenantId = mobile.tenantId;
        this.title = mobile.title;
        this.description = mobile.description;
        this.androidAppId = mobile.androidAppId;
        this.iosAppId = mobile.iosAppId;
        this.layoutConfig = mobile.layoutConfig;
        this.oauth2Enabled = mobile.oauth2Enabled;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Schema(description="Mobile app bundle title", example="My main application", accessMode=Schema.AccessMode.READ_ONLY)
    public String getName() {
        return this.title;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MobileAppBundle)) {
            return false;
        }
        MobileAppBundle other = (MobileAppBundle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$oauth2Enabled = this.getOauth2Enabled();
        Boolean other$oauth2Enabled = other.getOauth2Enabled();
        if (this$oauth2Enabled == null ? other$oauth2Enabled != null : !((Object)this$oauth2Enabled).equals(other$oauth2Enabled)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        MobileAppId this$androidAppId = this.getAndroidAppId();
        MobileAppId other$androidAppId = other.getAndroidAppId();
        if (this$androidAppId == null ? other$androidAppId != null : !((Object)this$androidAppId).equals(other$androidAppId)) {
            return false;
        }
        MobileAppId this$iosAppId = this.getIosAppId();
        MobileAppId other$iosAppId = other.getIosAppId();
        if (this$iosAppId == null ? other$iosAppId != null : !((Object)this$iosAppId).equals(other$iosAppId)) {
            return false;
        }
        MobileLayoutConfig this$layoutConfig = this.getLayoutConfig();
        MobileLayoutConfig other$layoutConfig = other.getLayoutConfig();
        return !(this$layoutConfig == null ? other$layoutConfig != null : !((Object)this$layoutConfig).equals(other$layoutConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MobileAppBundle;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $oauth2Enabled = this.getOauth2Enabled();
        result = result * 59 + ($oauth2Enabled == null ? 43 : ((Object)$oauth2Enabled).hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        MobileAppId $androidAppId = this.getAndroidAppId();
        result = result * 59 + ($androidAppId == null ? 43 : ((Object)$androidAppId).hashCode());
        MobileAppId $iosAppId = this.getIosAppId();
        result = result * 59 + ($iosAppId == null ? 43 : ((Object)$iosAppId).hashCode());
        MobileLayoutConfig $layoutConfig = this.getLayoutConfig();
        result = result * 59 + ($layoutConfig == null ? 43 : ((Object)$layoutConfig).hashCode());
        return result;
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public MobileAppId getAndroidAppId() {
        return this.androidAppId;
    }

    @Generated
    public MobileAppId getIosAppId() {
        return this.iosAppId;
    }

    @Generated
    public MobileLayoutConfig getLayoutConfig() {
        return this.layoutConfig;
    }

    @Generated
    public Boolean getOauth2Enabled() {
        return this.oauth2Enabled;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setAndroidAppId(MobileAppId androidAppId) {
        this.androidAppId = androidAppId;
    }

    @Generated
    public void setIosAppId(MobileAppId iosAppId) {
        this.iosAppId = iosAppId;
    }

    @Generated
    public void setLayoutConfig(MobileLayoutConfig layoutConfig) {
        this.layoutConfig = layoutConfig;
    }

    @Generated
    public void setOauth2Enabled(Boolean oauth2Enabled) {
        this.oauth2Enabled = oauth2Enabled;
    }

    @Override
    @Generated
    public String toString() {
        return "MobileAppBundle(tenantId=" + String.valueOf(this.getTenantId()) + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", androidAppId=" + String.valueOf(this.getAndroidAppId()) + ", iosAppId=" + String.valueOf(this.getIosAppId()) + ", layoutConfig=" + String.valueOf(this.getLayoutConfig()) + ", oauth2Enabled=" + this.getOauth2Enabled() + ")";
    }
}

