/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.limit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.thingsboard.server.common.data.limit.RateLimitEntry;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;

public class RateLimitUtil {
    public static List<RateLimitEntry> parseConfig(String config) {
        if (config == null || config.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(config.split(",")).map(RateLimitEntry::parse).toList();
    }

    public static Function<DefaultTenantProfileConfiguration, String> merge(Function<DefaultTenantProfileConfiguration, String> configExtractor1, Function<DefaultTenantProfileConfiguration, String> configExtractor2) {
        return config -> {
            String config1 = (String)configExtractor1.apply((DefaultTenantProfileConfiguration)config);
            String config2 = (String)configExtractor2.apply((DefaultTenantProfileConfiguration)config);
            return RateLimitUtil.mergeStrConfigs(config1, config2);
        };
    }

    private static String mergeStrConfigs(String firstConfig, String secondConfig) {
        ArrayList<RateLimitEntry> all = new ArrayList<RateLimitEntry>();
        all.addAll(RateLimitUtil.parseConfig(firstConfig));
        all.addAll(RateLimitUtil.parseConfig(secondConfig));
        HashMap<Long, Long> merged = new HashMap<Long, Long>();
        for (RateLimitEntry entry : all) {
            merged.merge(entry.durationSeconds(), entry.capacity(), Long::sum);
        }
        return merged.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> String.valueOf(e.getValue()) + ":" + String.valueOf(e.getKey())).collect(Collectors.joining(","));
    }

    public static boolean isValid(String configStr) {
        List<RateLimitEntry> limitedApiEntries = RateLimitUtil.parseConfig(configStr);
        HashSet<Long> distinctDurations = new HashSet<Long>();
        for (RateLimitEntry entry : limitedApiEntries) {
            if (distinctDurations.add(entry.durationSeconds())) continue;
            return false;
        }
        return true;
    }
}

