/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.limit;

import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.thingsboard.server.common.data.limit.RateLimitUtil;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;

public enum LimitedApi {
    ENTITY_EXPORT(DefaultTenantProfileConfiguration::getTenantEntityExportRateLimit, "entity version creation", true),
    ENTITY_IMPORT(DefaultTenantProfileConfiguration::getTenantEntityImportRateLimit, "entity version load", true),
    NOTIFICATION_REQUESTS(DefaultTenantProfileConfiguration::getTenantNotificationRequestsRateLimit, "notification requests", true),
    NOTIFICATION_REQUESTS_PER_RULE(DefaultTenantProfileConfiguration::getTenantNotificationRequestsPerRuleRateLimit, "notification requests per rule", false),
    REST_REQUESTS_PER_TENANT(DefaultTenantProfileConfiguration::getTenantServerRestLimitsConfiguration, "REST API requests", true),
    REST_REQUESTS_PER_CUSTOMER(DefaultTenantProfileConfiguration::getCustomerServerRestLimitsConfiguration, "REST API requests per customer", false),
    WS_UPDATES_PER_SESSION(DefaultTenantProfileConfiguration::getWsUpdatesPerSessionRateLimit, "WS updates per session", true),
    CASSANDRA_WRITE_QUERIES_CORE(DefaultTenantProfileConfiguration::getCassandraWriteQueryTenantCoreRateLimits, "Rest API Cassandra write queries", true),
    CASSANDRA_READ_QUERIES_CORE(DefaultTenantProfileConfiguration::getCassandraReadQueryTenantCoreRateLimits, "Rest API and WS telemetry Cassandra read queries", true),
    CASSANDRA_WRITE_QUERIES_RULE_ENGINE(DefaultTenantProfileConfiguration::getCassandraWriteQueryTenantRuleEngineRateLimits, "Rule Engine telemetry Cassandra write queries", true),
    CASSANDRA_READ_QUERIES_RULE_ENGINE(DefaultTenantProfileConfiguration::getCassandraReadQueryTenantRuleEngineRateLimits, "Rule Engine telemetry Cassandra read queries", true),
    CASSANDRA_READ_QUERIES_MONOLITH(RateLimitUtil.merge(DefaultTenantProfileConfiguration::getCassandraReadQueryTenantCoreRateLimits, DefaultTenantProfileConfiguration::getCassandraReadQueryTenantRuleEngineRateLimits), "Monolith telemetry Cassandra read queries", true),
    CASSANDRA_WRITE_QUERIES_MONOLITH(RateLimitUtil.merge(DefaultTenantProfileConfiguration::getCassandraWriteQueryTenantCoreRateLimits, DefaultTenantProfileConfiguration::getCassandraWriteQueryTenantRuleEngineRateLimits), "Monolith telemetry Cassandra write queries", true),
    CASSANDRA_QUERIES(null, true),
    EDGE_EVENTS(DefaultTenantProfileConfiguration::getEdgeEventRateLimits, "Edge events", true),
    EDGE_EVENTS_PER_EDGE(DefaultTenantProfileConfiguration::getEdgeEventRateLimitsPerEdge, "Edge events per edge", false),
    EDGE_UPLINK_MESSAGES(DefaultTenantProfileConfiguration::getEdgeUplinkMessagesRateLimits, "Edge uplink messages", true),
    EDGE_UPLINK_MESSAGES_PER_EDGE(DefaultTenantProfileConfiguration::getEdgeUplinkMessagesRateLimitsPerEdge, "Edge uplink messages per edge", false),
    PASSWORD_RESET(false, true),
    TWO_FA_VERIFICATION_CODE_SEND(false, true),
    TWO_FA_VERIFICATION_CODE_CHECK(false, true),
    TRANSPORT_MESSAGES_PER_TENANT("transport messages", true),
    TRANSPORT_MESSAGES_PER_DEVICE("transport messages per device", false),
    TRANSPORT_MESSAGES_PER_GATEWAY("transport messages per gateway", false),
    TRANSPORT_MESSAGES_PER_GATEWAY_DEVICE("transport messages per gateway device", false),
    EMAILS("emails sending", true),
    WS_SUBSCRIPTIONS("WS subscriptions", false),
    CALCULATED_FIELD_DEBUG_EVENTS("calculated field debug events", true);

    private final Function<DefaultTenantProfileConfiguration, String> configExtractor;
    private final boolean perTenant;
    private final boolean refillRateLimitIntervally;
    private final String label;

    private LimitedApi(Function<DefaultTenantProfileConfiguration, String> configExtractor, String label, boolean perTenant) {
        this(configExtractor, label, perTenant, false);
    }

    private LimitedApi(boolean perTenant, boolean refillRateLimitIntervally) {
        this(null, null, perTenant, refillRateLimitIntervally);
    }

    private LimitedApi(String label, boolean perTenant) {
        this(null, label, perTenant, false);
    }

    private LimitedApi(Function<DefaultTenantProfileConfiguration, String> configExtractor, String label, boolean perTenant, boolean refillRateLimitIntervally) {
        this.configExtractor = configExtractor;
        this.label = label;
        this.perTenant = perTenant;
        this.refillRateLimitIntervally = refillRateLimitIntervally;
    }

    public String getLimitConfig(DefaultTenantProfileConfiguration profileConfiguration) {
        return Optional.ofNullable(this.configExtractor).map(extractor -> (String)extractor.apply(profileConfiguration)).orElse(null);
    }

    @Generated
    public Function<DefaultTenantProfileConfiguration, String> getConfigExtractor() {
        return this.configExtractor;
    }

    @Generated
    public boolean isPerTenant() {
        return this.perTenant;
    }

    @Generated
    public boolean isRefillRateLimitIntervally() {
        return this.refillRateLimitIntervally;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }
}

