/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.kv;

import java.time.ZoneId;
import lombok.Generated;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.AggregationParams;
import org.thingsboard.server.common.data.kv.BaseTsKvQuery;
import org.thingsboard.server.common.data.kv.IntervalType;
import org.thingsboard.server.common.data.kv.ReadTsKvQuery;

public class BaseReadTsKvQuery
extends BaseTsKvQuery
implements ReadTsKvQuery {
    private final AggregationParams aggParameters;
    private final int limit;
    private final String order;

    public BaseReadTsKvQuery(String key, long startTs, long endTs, long interval, int limit, Aggregation aggregation) {
        this(key, startTs, endTs, interval, limit, aggregation, "DESC");
    }

    public BaseReadTsKvQuery(String key, long startTs, long endTs, long interval, int limit, Aggregation aggregation, String descOrder) {
        this(key, startTs, endTs, AggregationParams.of(aggregation, IntervalType.MILLISECONDS, ZoneId.systemDefault(), interval), limit, descOrder);
    }

    public BaseReadTsKvQuery(String key, long startTs, long endTs, AggregationParams parameters, int limit) {
        this(key, startTs, endTs, parameters, limit, "DESC");
    }

    public BaseReadTsKvQuery(String key, long startTs, long endTs, AggregationParams parameters, int limit, String order) {
        super(key, startTs, endTs);
        this.aggParameters = parameters;
        this.limit = limit;
        this.order = order;
    }

    public BaseReadTsKvQuery(String key, long startTs, long endTs) {
        this(key, startTs, endTs, AggregationParams.milliseconds(Aggregation.AVG, endTs - startTs), 1, "DESC");
    }

    public BaseReadTsKvQuery(String key, long startTs, long endTs, int limit, String order) {
        this(key, startTs, endTs, AggregationParams.none(), limit, order);
    }

    public BaseReadTsKvQuery(ReadTsKvQuery query, long startTs, long endTs) {
        super(query.getId(), query.getKey(), startTs, endTs);
        this.aggParameters = query.getAggParameters();
        this.limit = query.getLimit();
        this.order = query.getOrder();
    }

    @Override
    @Generated
    public AggregationParams getAggParameters() {
        return this.aggParameters;
    }

    @Override
    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Override
    @Generated
    public String getOrder() {
        return this.order;
    }

    @Override
    @Generated
    public String toString() {
        return "BaseReadTsKvQuery(aggParameters=" + String.valueOf(this.getAggParameters()) + ", limit=" + this.getLimit() + ", order=" + this.getOrder() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseReadTsKvQuery)) {
            return false;
        }
        BaseReadTsKvQuery other = (BaseReadTsKvQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        AggregationParams this$aggParameters = this.getAggParameters();
        AggregationParams other$aggParameters = other.getAggParameters();
        if (this$aggParameters == null ? other$aggParameters != null : !((Object)this$aggParameters).equals(other$aggParameters)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        return !(this$order == null ? other$order != null : !this$order.equals(other$order));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseReadTsKvQuery;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getLimit();
        AggregationParams $aggParameters = this.getAggParameters();
        result = result * 59 + ($aggParameters == null ? 43 : ((Object)$aggParameters).hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        return result;
    }
}

