/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.job.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.JobId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.common.data.job.task.DummyTask;
import org.thingsboard.server.common.data.job.task.TaskResult;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="jobType")
@JsonSubTypes(value={@JsonSubTypes.Type(name="DUMMY", value=DummyTask.class)})
public abstract class Task<R extends TaskResult> {
    private TenantId tenantId;
    private JobId jobId;
    private String key;
    private int retries;
    private int attempt = 0;

    public Task() {
    }

    public abstract R toFailed(Throwable var1);

    public abstract R toDiscarded();

    @JsonIgnore
    public abstract EntityId getEntityId();

    @JsonIgnore
    public abstract JobType getJobType();

    @Generated
    protected Task(TaskBuilder<R, ?, ?> b) {
        this.tenantId = b.tenantId;
        this.jobId = b.jobId;
        this.key = b.key;
        this.retries = b.retries;
        this.attempt = b.attempt;
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public JobId getJobId() {
        return this.jobId;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public int getRetries() {
        return this.retries;
    }

    @Generated
    public int getAttempt() {
        return this.attempt;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setJobId(JobId jobId) {
        this.jobId = jobId;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setRetries(int retries) {
        this.retries = retries;
    }

    @Generated
    public void setAttempt(int attempt) {
        this.attempt = attempt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRetries() != other.getRetries()) {
            return false;
        }
        if (this.getAttempt() != other.getAttempt()) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        JobId this$jobId = this.getJobId();
        JobId other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRetries();
        result = result * 59 + this.getAttempt();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        JobId $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Task(tenantId=" + String.valueOf(this.getTenantId()) + ", jobId=" + String.valueOf(this.getJobId()) + ", key=" + this.getKey() + ", retries=" + this.getRetries() + ", attempt=" + this.getAttempt() + ")";
    }

    @ConstructorProperties(value={"tenantId", "jobId", "key", "retries", "attempt"})
    @Generated
    public Task(TenantId tenantId, JobId jobId, String key, int retries, int attempt) {
        this.tenantId = tenantId;
        this.jobId = jobId;
        this.key = key;
        this.retries = retries;
        this.attempt = attempt;
    }

    @Generated
    public static abstract class TaskBuilder<R extends TaskResult, C extends Task<R>, B extends TaskBuilder<R, C, B>> {
        @Generated
        private TenantId tenantId;
        @Generated
        private JobId jobId;
        @Generated
        private String key;
        @Generated
        private int retries;
        @Generated
        private int attempt;

        @Generated
        public B tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        @Generated
        public B jobId(JobId jobId) {
            this.jobId = jobId;
            return this.self();
        }

        @Generated
        public B key(String key) {
            this.key = key;
            return this.self();
        }

        @Generated
        public B retries(int retries) {
            this.retries = retries;
            return this.self();
        }

        @Generated
        public B attempt(int attempt) {
            this.attempt = attempt;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Task.TaskBuilder(tenantId=" + String.valueOf(this.tenantId) + ", jobId=" + String.valueOf(this.jobId) + ", key=" + this.key + ", retries=" + this.retries + ", attempt=" + this.attempt + ")";
        }
    }
}

