/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.job;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.job.DummyJobResult;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.common.data.job.task.TaskResult;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="jobType")
@JsonSubTypes(value={@JsonSubTypes.Type(name="DUMMY", value=DummyJobResult.class)})
public abstract class JobResult
implements Serializable {
    private int successfulCount;
    private int failedCount;
    private int discardedCount;
    private Integer totalCount = null;
    private List<TaskResult> results = new ArrayList<TaskResult>();
    private String generalError;
    private long startTs;
    private long finishTs;
    private long cancellationTs;

    @JsonIgnore
    public int getCompletedCount() {
        return this.successfulCount + this.failedCount + this.discardedCount;
    }

    public void processTaskResult(TaskResult taskResult) {
        if (taskResult.isSuccess()) {
            ++this.successfulCount;
        } else if (taskResult.isDiscarded()) {
            ++this.discardedCount;
        } else {
            ++this.failedCount;
            if (this.results.size() < 100) {
                this.results.add(taskResult);
            }
        }
    }

    @JsonIgnore
    public abstract JobType getJobType();

    @Generated
    public int getSuccessfulCount() {
        return this.successfulCount;
    }

    @Generated
    public int getFailedCount() {
        return this.failedCount;
    }

    @Generated
    public int getDiscardedCount() {
        return this.discardedCount;
    }

    @Generated
    public Integer getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public List<TaskResult> getResults() {
        return this.results;
    }

    @Generated
    public String getGeneralError() {
        return this.generalError;
    }

    @Generated
    public long getStartTs() {
        return this.startTs;
    }

    @Generated
    public long getFinishTs() {
        return this.finishTs;
    }

    @Generated
    public long getCancellationTs() {
        return this.cancellationTs;
    }

    @Generated
    public void setSuccessfulCount(int successfulCount) {
        this.successfulCount = successfulCount;
    }

    @Generated
    public void setFailedCount(int failedCount) {
        this.failedCount = failedCount;
    }

    @Generated
    public void setDiscardedCount(int discardedCount) {
        this.discardedCount = discardedCount;
    }

    @Generated
    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    @Generated
    public void setResults(List<TaskResult> results) {
        this.results = results;
    }

    @Generated
    public void setGeneralError(String generalError) {
        this.generalError = generalError;
    }

    @Generated
    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    @Generated
    public void setFinishTs(long finishTs) {
        this.finishTs = finishTs;
    }

    @Generated
    public void setCancellationTs(long cancellationTs) {
        this.cancellationTs = cancellationTs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobResult)) {
            return false;
        }
        JobResult other = (JobResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSuccessfulCount() != other.getSuccessfulCount()) {
            return false;
        }
        if (this.getFailedCount() != other.getFailedCount()) {
            return false;
        }
        if (this.getDiscardedCount() != other.getDiscardedCount()) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getFinishTs() != other.getFinishTs()) {
            return false;
        }
        if (this.getCancellationTs() != other.getCancellationTs()) {
            return false;
        }
        Integer this$totalCount = this.getTotalCount();
        Integer other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        List<TaskResult> this$results = this.getResults();
        List<TaskResult> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        String this$generalError = this.getGeneralError();
        String other$generalError = other.getGeneralError();
        return !(this$generalError == null ? other$generalError != null : !this$generalError.equals(other$generalError));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JobResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSuccessfulCount();
        result = result * 59 + this.getFailedCount();
        result = result * 59 + this.getDiscardedCount();
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $finishTs = this.getFinishTs();
        result = result * 59 + (int)($finishTs >>> 32 ^ $finishTs);
        long $cancellationTs = this.getCancellationTs();
        result = result * 59 + (int)($cancellationTs >>> 32 ^ $cancellationTs);
        Integer $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        List<TaskResult> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        String $generalError = this.getGeneralError();
        result = result * 59 + ($generalError == null ? 43 : $generalError.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JobResult(successfulCount=" + this.getSuccessfulCount() + ", failedCount=" + this.getFailedCount() + ", discardedCount=" + this.getDiscardedCount() + ", totalCount=" + this.getTotalCount() + ", results=" + String.valueOf(this.getResults()) + ", generalError=" + this.getGeneralError() + ", startTs=" + this.getStartTs() + ", finishTs=" + this.getFinishTs() + ", cancellationTs=" + this.getCancellationTs() + ")";
    }

    @Generated
    public JobResult() {
    }
}

