/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.job;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasTenantId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.JobId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.job.DummyJobResult;
import org.thingsboard.server.common.data.job.JobConfiguration;
import org.thingsboard.server.common.data.job.JobResult;
import org.thingsboard.server.common.data.job.JobStatus;
import org.thingsboard.server.common.data.job.JobType;

public class Job
extends BaseData<JobId>
implements HasTenantId {
    @NotNull
    private TenantId tenantId;
    @NotNull
    private JobType type;
    @NotBlank
    private String key;
    @NotNull
    private EntityId entityId;
    private String entityName;
    @NotNull
    private JobStatus status;
    @NotNull
    @Valid
    private JobConfiguration configuration;
    @NotNull
    private JobResult result;
    public static final Set<EntityType> SUPPORTED_ENTITY_TYPES = Set.of(EntityType.DEVICE, EntityType.ASSET, EntityType.DEVICE_PROFILE, EntityType.ASSET_PROFILE);

    public Job(TenantId tenantId, JobType type, String key, EntityId entityId, JobConfiguration configuration) {
        this.tenantId = tenantId;
        this.type = type;
        this.key = key;
        this.entityId = entityId;
        this.configuration = configuration;
        this.configuration.setTasksKey(UUID.randomUUID().toString());
        this.presetResult();
    }

    public void presetResult() {
        switch (this.type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DUMMY: 
        }
        this.result = new DummyJobResult();
    }

    public <C extends JobConfiguration> C getConfiguration() {
        return (C)this.configuration;
    }

    @Generated
    public static JobBuilder builder() {
        return new JobBuilder();
    }

    @Generated
    public JobBuilder toBuilder() {
        return new JobBuilder().tenantId(this.tenantId).type(this.type).key(this.key).entityId(this.entityId).configuration(this.configuration);
    }

    @Override
    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public JobType getType() {
        return this.type;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getEntityName() {
        return this.entityName;
    }

    @Generated
    public JobStatus getStatus() {
        return this.status;
    }

    @Generated
    public JobResult getResult() {
        return this.result;
    }

    @Generated
    public void setTenantId(TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setType(JobType type) {
        this.type = type;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    @Generated
    public void setStatus(JobStatus status) {
        this.status = status;
    }

    @Generated
    public void setConfiguration(JobConfiguration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setResult(JobResult result) {
        this.result = result;
    }

    @Generated
    public Job() {
    }

    @Override
    @Generated
    public String toString() {
        return "Job(super=" + super.toString() + ", tenantId=" + String.valueOf(this.getTenantId()) + ", type=" + String.valueOf((Object)this.getType()) + ", key=" + this.getKey() + ", entityId=" + String.valueOf(this.getEntityId()) + ", entityName=" + this.getEntityName() + ", status=" + String.valueOf((Object)this.getStatus()) + ", configuration=" + String.valueOf(this.getConfiguration()) + ", result=" + String.valueOf(this.getResult()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Job)) {
            return false;
        }
        Job other = (Job)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        JobType this$type = this.getType();
        JobType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        EntityId this$entityId = this.getEntityId();
        EntityId other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        String this$entityName = this.getEntityName();
        String other$entityName = other.getEntityName();
        if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
            return false;
        }
        JobStatus this$status = this.getStatus();
        JobStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Object this$configuration = this.getConfiguration();
        Object other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        JobResult this$result = this.getResult();
        JobResult other$result = other.getResult();
        return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Job;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        JobType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        EntityId $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        String $entityName = this.getEntityName();
        result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
        JobStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Object $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        JobResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        return result;
    }

    @Generated
    public static class JobBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private JobType type;
        @Generated
        private String key;
        @Generated
        private EntityId entityId;
        @Generated
        private JobConfiguration configuration;

        @Generated
        JobBuilder() {
        }

        @Generated
        public JobBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public JobBuilder type(JobType type) {
            this.type = type;
            return this;
        }

        @Generated
        public JobBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public JobBuilder entityId(EntityId entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public JobBuilder configuration(JobConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public Job build() {
            return new Job(this.tenantId, this.type, this.key, this.entityId, this.configuration);
        }

        @Generated
        public String toString() {
            return "Job.JobBuilder(tenantId=" + String.valueOf(this.tenantId) + ", type=" + String.valueOf((Object)this.type) + ", key=" + this.key + ", entityId=" + String.valueOf(this.entityId) + ", configuration=" + String.valueOf(this.configuration) + ")";
        }
    }
}

