/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.id;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.UUID;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.UUIDBased;

public final class TenantId
extends UUIDBased
implements EntityId {
    @JsonIgnore
    static final ConcurrentReferenceHashMap<UUID, TenantId> tenants = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    @JsonIgnore
    public static final TenantId SYS_TENANT_ID = TenantId.fromUUID(EntityId.NULL_UUID);
    private static final long serialVersionUID = 1L;

    @JsonCreator
    public static TenantId fromUUID(@JsonProperty(value="id") UUID id) {
        return (TenantId)tenants.computeIfAbsent((Object)id, TenantId::new);
    }

    @Deprecated
    public TenantId(UUID id) {
        super(id);
    }

    @JsonIgnore
    public boolean isSysTenantId() {
        return this.equals(SYS_TENANT_ID);
    }

    @Override
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="string", example="TENANT", allowableValues={"TENANT"})
    public EntityType getEntityType() {
        return EntityType.TENANT;
    }
}

