/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.id;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.UUID;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.UUIDBased;

public class EntityViewId
extends UUIDBased
implements EntityId {
    private static final long serialVersionUID = 1L;

    @JsonCreator
    public EntityViewId(@JsonProperty(value="id") UUID id) {
        super(id);
    }

    public static EntityViewId fromString(String entityViewID) {
        return new EntityViewId(UUID.fromString(entityViewID));
    }

    @Override
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="string", example="ENTITY_VIEW", allowableValues={"ENTITY_VIEW"})
    public EntityType getEntityType() {
        return EntityType.ENTITY_VIEW;
    }
}

