/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.id;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.UUID;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.UUIDBased;

@Schema
public class DeviceId
extends UUIDBased
implements EntityId {
    private static final long serialVersionUID = 1L;

    @JsonCreator
    public DeviceId(@JsonProperty(value="id") UUID id) {
        super(id);
    }

    public static DeviceId fromString(String deviceId) {
        return new DeviceId(UUID.fromString(deviceId));
    }

    @Override
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="string", example="DEVICE", allowableValues={"DEVICE"})
    public EntityType getEntityType() {
        return EntityType.DEVICE;
    }
}

