/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.id.TenantId;

public class StatisticsEvent
extends Event {
    private static final long serialVersionUID = 6683733979448910631L;
    private final long messagesProcessed;
    private final long errorsOccurred;

    private StatisticsEvent(TenantId tenantId, UUID entityId, String serviceId, UUID id, long ts, long messagesProcessed, long errorsOccurred) {
        super(tenantId, entityId, serviceId, id, ts);
        this.messagesProcessed = messagesProcessed;
        this.errorsOccurred = errorsOccurred;
    }

    @Override
    public EventType getType() {
        return EventType.STATS;
    }

    @Override
    public EventInfo toInfo(EntityType entityType) {
        EventInfo eventInfo = super.toInfo(entityType);
        ObjectNode json = (ObjectNode)eventInfo.getBody();
        json.put("messagesProcessed", this.messagesProcessed).put("errorsOccurred", this.errorsOccurred);
        return eventInfo;
    }

    @Generated
    public static StatisticsEventBuilder builder() {
        return new StatisticsEventBuilder();
    }

    @Override
    @Generated
    public String toString() {
        return "StatisticsEvent(messagesProcessed=" + this.getMessagesProcessed() + ", errorsOccurred=" + this.getErrorsOccurred() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticsEvent)) {
            return false;
        }
        StatisticsEvent other = (StatisticsEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMessagesProcessed() != other.getMessagesProcessed()) {
            return false;
        }
        return this.getErrorsOccurred() == other.getErrorsOccurred();
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StatisticsEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $messagesProcessed = this.getMessagesProcessed();
        result = result * 59 + (int)($messagesProcessed >>> 32 ^ $messagesProcessed);
        long $errorsOccurred = this.getErrorsOccurred();
        result = result * 59 + (int)($errorsOccurred >>> 32 ^ $errorsOccurred);
        return result;
    }

    @Generated
    public long getMessagesProcessed() {
        return this.messagesProcessed;
    }

    @Generated
    public long getErrorsOccurred() {
        return this.errorsOccurred;
    }

    @Generated
    public static class StatisticsEventBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private UUID entityId;
        @Generated
        private String serviceId;
        @Generated
        private UUID id;
        @Generated
        private long ts;
        @Generated
        private long messagesProcessed;
        @Generated
        private long errorsOccurred;

        @Generated
        StatisticsEventBuilder() {
        }

        @Generated
        public StatisticsEventBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public StatisticsEventBuilder entityId(UUID entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public StatisticsEventBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Generated
        public StatisticsEventBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        @Generated
        public StatisticsEventBuilder ts(long ts) {
            this.ts = ts;
            return this;
        }

        @Generated
        public StatisticsEventBuilder messagesProcessed(long messagesProcessed) {
            this.messagesProcessed = messagesProcessed;
            return this;
        }

        @Generated
        public StatisticsEventBuilder errorsOccurred(long errorsOccurred) {
            this.errorsOccurred = errorsOccurred;
            return this;
        }

        @Generated
        public StatisticsEvent build() {
            return new StatisticsEvent(this.tenantId, this.entityId, this.serviceId, this.id, this.ts, this.messagesProcessed, this.errorsOccurred);
        }

        @Generated
        public String toString() {
            return "StatisticsEvent.StatisticsEventBuilder(tenantId=" + String.valueOf(this.tenantId) + ", entityId=" + String.valueOf(this.entityId) + ", serviceId=" + this.serviceId + ", id=" + String.valueOf(this.id) + ", ts=" + this.ts + ", messagesProcessed=" + this.messagesProcessed + ", errorsOccurred=" + this.errorsOccurred + ")";
        }
    }
}

