/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EventInfo;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.id.TenantId;

public class LifecycleEvent
extends Event {
    private static final long serialVersionUID = -3247420461850911549L;
    private final String lcEventType;
    private final boolean success;
    private String error;

    private LifecycleEvent(TenantId tenantId, UUID entityId, String serviceId, UUID id, long ts, String lcEventType, boolean success, String error) {
        super(tenantId, entityId, serviceId, id, ts);
        this.lcEventType = lcEventType;
        this.success = success;
        this.error = error;
    }

    @Override
    public EventType getType() {
        return EventType.LC_EVENT;
    }

    @Override
    public EventInfo toInfo(EntityType entityType) {
        EventInfo eventInfo = super.toInfo(entityType);
        ObjectNode json = (ObjectNode)eventInfo.getBody();
        json.put("event", this.lcEventType).put("success", this.success);
        if (this.error != null) {
            json.put("error", this.error);
        }
        return eventInfo;
    }

    @Generated
    public static LifecycleEventBuilder builder() {
        return new LifecycleEventBuilder();
    }

    @Override
    @Generated
    public String toString() {
        return "LifecycleEvent(lcEventType=" + this.getLcEventType() + ", success=" + this.isSuccess() + ", error=" + this.getError() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LifecycleEvent)) {
            return false;
        }
        LifecycleEvent other = (LifecycleEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$lcEventType = this.getLcEventType();
        String other$lcEventType = other.getLcEventType();
        if (this$lcEventType == null ? other$lcEventType != null : !this$lcEventType.equals(other$lcEventType)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LifecycleEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $lcEventType = this.getLcEventType();
        result = result * 59 + ($lcEventType == null ? 43 : $lcEventType.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    @Generated
    public String getLcEventType() {
        return this.lcEventType;
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public static class LifecycleEventBuilder {
        @Generated
        private TenantId tenantId;
        @Generated
        private UUID entityId;
        @Generated
        private String serviceId;
        @Generated
        private UUID id;
        @Generated
        private long ts;
        @Generated
        private String lcEventType;
        @Generated
        private boolean success;
        @Generated
        private String error;

        @Generated
        LifecycleEventBuilder() {
        }

        @Generated
        public LifecycleEventBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public LifecycleEventBuilder entityId(UUID entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public LifecycleEventBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Generated
        public LifecycleEventBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        @Generated
        public LifecycleEventBuilder ts(long ts) {
            this.ts = ts;
            return this;
        }

        @Generated
        public LifecycleEventBuilder lcEventType(String lcEventType) {
            this.lcEventType = lcEventType;
            return this;
        }

        @Generated
        public LifecycleEventBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        @Generated
        public LifecycleEventBuilder error(String error) {
            this.error = error;
            return this;
        }

        @Generated
        public LifecycleEvent build() {
            return new LifecycleEvent(this.tenantId, this.entityId, this.serviceId, this.id, this.ts, this.lcEventType, this.success, this.error);
        }

        @Generated
        public String toString() {
            return "LifecycleEvent.LifecycleEventBuilder(tenantId=" + String.valueOf(this.tenantId) + ", entityId=" + String.valueOf(this.entityId) + ", serviceId=" + this.serviceId + ", id=" + String.valueOf(this.id) + ", ts=" + this.ts + ", lcEventType=" + this.lcEventType + ", success=" + this.success + ", error=" + this.error + ")";
        }
    }
}

