/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.event.EventFilter;
import org.thingsboard.server.common.data.event.EventType;

@Schema
public class LifeCycleEventFilter
implements EventFilter {
    @Schema(description="String value representing the server name, identifier or ip address where the platform is running", example="ip-172-31-24-152")
    protected String server;
    @Schema(description="String value representing the lifecycle event type", example="STARTED")
    protected String event;
    @Schema(description="String value representing status of the lifecycle event", allowableValues={"Success", "Failure"})
    protected String status;
    @Schema(description="The case insensitive 'contains' filter based on error message", example="not present in the DB")
    protected String errorStr;

    @Override
    public EventType getEventType() {
        return EventType.LC_EVENT;
    }

    @Override
    public boolean isNotEmpty() {
        return !StringUtils.isEmpty(this.server) || !StringUtils.isEmpty(this.event) || !StringUtils.isEmpty(this.status) || !StringUtils.isEmpty(this.errorStr);
    }

    @Generated
    public LifeCycleEventFilter() {
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public String getEvent() {
        return this.event;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getErrorStr() {
        return this.errorStr;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setEvent(String event) {
        this.event = event;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setErrorStr(String errorStr) {
        this.errorStr = errorStr;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LifeCycleEventFilter)) {
            return false;
        }
        LifeCycleEventFilter other = (LifeCycleEventFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$errorStr = this.getErrorStr();
        String other$errorStr = other.getErrorStr();
        return !(this$errorStr == null ? other$errorStr != null : !this$errorStr.equals(other$errorStr));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LifeCycleEventFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $errorStr = this.getErrorStr();
        result = result * 59 + ($errorStr == null ? 43 : $errorStr.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LifeCycleEventFilter(server=" + this.getServer() + ", event=" + this.getEvent() + ", status=" + this.getStatus() + ", errorStr=" + this.getErrorStr() + ")";
    }
}

