/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.event;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.event.EventFilter;

@Schema
public abstract class DebugEventFilter
implements EventFilter {
    @Schema(description="String value representing the server name, identifier or ip address where the platform is running", example="ip-172-31-24-152")
    protected String server;
    @Schema(description="Boolean value to filter the errors", allowableValues={"false", "true"})
    protected boolean isError;
    @Schema(description="The case insensitive 'contains' filter based on error message", example="not present in the DB")
    protected String errorStr;

    public void setIsError(boolean isError) {
        this.isError = isError;
    }

    @Override
    public boolean isNotEmpty() {
        return !StringUtils.isEmpty(this.server) || this.isError || !StringUtils.isEmpty(this.errorStr);
    }

    @Generated
    public DebugEventFilter() {
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public boolean isError() {
        return this.isError;
    }

    @Generated
    public String getErrorStr() {
        return this.errorStr;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setErrorStr(String errorStr) {
        this.errorStr = errorStr;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebugEventFilter)) {
            return false;
        }
        DebugEventFilter other = (DebugEventFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isError() != other.isError()) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$errorStr = this.getErrorStr();
        String other$errorStr = other.getErrorStr();
        return !(this$errorStr == null ? other$errorStr != null : !this$errorStr.equals(other$errorStr));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebugEventFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isError() ? 79 : 97);
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $errorStr = this.getErrorStr();
        result = result * 59 + ($errorStr == null ? 43 : $errorStr.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebugEventFilter(server=" + this.getServer() + ", isError=" + this.isError() + ", errorStr=" + this.getErrorStr() + ")";
    }
}

