/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.edqs.fields;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.EntityId;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public interface EntityFields {
    public static final Logger log = LoggerFactory.getLogger(EntityFields.class);

    public UUID getId();

    default public UUID getTenantId() {
        return null;
    }

    default public UUID getCustomerId() {
        return null;
    }

    default public List<UUID> getAssignedCustomerIds() {
        return Collections.emptyList();
    }

    default public long getCreatedTime() {
        return 0L;
    }

    default public String getName() {
        return "";
    }

    default public String getType() {
        return "";
    }

    default public String getLabel() {
        return "";
    }

    default public String getAdditionalInfo() {
        return "";
    }

    default public String getEmail() {
        return "";
    }

    default public String getCountry() {
        return "";
    }

    default public String getState() {
        return "";
    }

    default public String getCity() {
        return "";
    }

    default public String getAddress() {
        return "";
    }

    default public String getAddress2() {
        return "";
    }

    default public String getZip() {
        return "";
    }

    default public String getPhone() {
        return "";
    }

    default public String getRegion() {
        return "";
    }

    default public String getFirstName() {
        return "";
    }

    default public String getLastName() {
        return "";
    }

    default public boolean isEdgeTemplate() {
        return false;
    }

    default public String getConfiguration() {
        return "";
    }

    default public String getSchedule() {
        return "";
    }

    default public EntityId getOriginatorId() {
        return null;
    }

    default public String getQueueName() {
        return "";
    }

    default public String getServiceId() {
        return "";
    }

    default public boolean isDefault() {
        return false;
    }

    default public UUID getOwnerId() {
        return null;
    }

    default public Long getVersion() {
        return null;
    }

    default public String getAsString(String key) {
        return switch (key) {
            case "id" -> this.getId().toString();
            case "createdTime" -> Long.toString(this.getCreatedTime());
            case "title" -> this.getName();
            case "type" -> this.getType();
            case "label" -> this.getLabel();
            case "additionalInfo" -> this.getAdditionalInfo();
            case "email" -> this.getEmail();
            case "country" -> this.getCountry();
            case "state" -> this.getState();
            case "city" -> this.getCity();
            case "address" -> this.getAddress();
            case "address2" -> this.getAddress2();
            case "zip" -> this.getZip();
            case "phone" -> this.getPhone();
            case "region" -> this.getRegion();
            case "firstName" -> this.getFirstName();
            case "lastName" -> this.getLastName();
            case "edgeTemplate" -> Boolean.toString(this.isEdgeTemplate());
            case "configuration" -> this.getConfiguration();
            case "schedule" -> this.getSchedule();
            case "originatorId" -> this.getOriginatorId().getId().toString();
            case "originatorType" -> this.getOriginatorId().getEntityType().toString();
            case "queueName" -> this.getQueueName();
            case "serviceId" -> this.getServiceId();
            default -> {
                log.warn("Unknown field '{}'", (Object)key);
                yield null;
            }
        };
    }
}

