/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.edqs.fields;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.server.common.data.edqs.fields.AbstractEntityFields;

public class DashboardFields
extends AbstractEntityFields {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private List<UUID> assignedCustomerIds;

    public DashboardFields(UUID id, long createdTime, UUID tenantId, String assignedCustomers, String name, Long version) {
        super(id, createdTime, tenantId, name, version);
        this.assignedCustomerIds = DashboardFields.getCustomerIds(assignedCustomers);
    }

    private static List<UUID> getCustomerIds(String assignedCustomers) {
        ArrayList<UUID> ids = new ArrayList<UUID>();
        if (assignedCustomers == null || assignedCustomers.isEmpty()) {
            return ids;
        }
        try {
            JsonNode rootNode = objectMapper.readTree(assignedCustomers);
            for (JsonNode node : rootNode) {
                String idStr = node.path("customerId").path("id").asText();
                if (idStr.isEmpty()) continue;
                ids.add(UUID.fromString(idStr));
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return ids;
    }

    @Generated
    protected DashboardFields(DashboardFieldsBuilder<?, ?> b) {
        super(b);
        this.assignedCustomerIds = b.assignedCustomerIds;
    }

    @Generated
    public static DashboardFieldsBuilder<?, ?> builder() {
        return new DashboardFieldsBuilderImpl();
    }

    @Override
    @Generated
    public List<UUID> getAssignedCustomerIds() {
        return this.assignedCustomerIds;
    }

    @Generated
    public void setAssignedCustomerIds(List<UUID> assignedCustomerIds) {
        this.assignedCustomerIds = assignedCustomerIds;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashboardFields)) {
            return false;
        }
        DashboardFields other = (DashboardFields)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<UUID> this$assignedCustomerIds = this.getAssignedCustomerIds();
        List<UUID> other$assignedCustomerIds = other.getAssignedCustomerIds();
        return !(this$assignedCustomerIds == null ? other$assignedCustomerIds != null : !((Object)this$assignedCustomerIds).equals(other$assignedCustomerIds));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DashboardFields;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UUID> $assignedCustomerIds = this.getAssignedCustomerIds();
        result = result * 59 + ($assignedCustomerIds == null ? 43 : ((Object)$assignedCustomerIds).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DashboardFields(assignedCustomerIds=" + String.valueOf(this.getAssignedCustomerIds()) + ")";
    }

    @Generated
    public DashboardFields() {
    }

    @Generated
    public static abstract class DashboardFieldsBuilder<C extends DashboardFields, B extends DashboardFieldsBuilder<C, B>>
    extends AbstractEntityFields.AbstractEntityFieldsBuilder<C, B> {
        @Generated
        private List<UUID> assignedCustomerIds;

        @Generated
        public B assignedCustomerIds(List<UUID> assignedCustomerIds) {
            this.assignedCustomerIds = assignedCustomerIds;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DashboardFields.DashboardFieldsBuilder(super=" + super.toString() + ", assignedCustomerIds=" + String.valueOf(this.assignedCustomerIds) + ")";
        }
    }

    @Generated
    private static final class DashboardFieldsBuilderImpl
    extends DashboardFieldsBuilder<DashboardFields, DashboardFieldsBuilderImpl> {
        @Generated
        private DashboardFieldsBuilderImpl() {
        }

        @Override
        @Generated
        protected DashboardFieldsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DashboardFields build() {
            return new DashboardFields(this);
        }
    }
}

